/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractWALRoller<T extends Abortable>
extends Thread
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWALRoller.class);
    protected static final String WAL_ROLL_PERIOD_KEY = "hbase.regionserver.logroll.period";
    protected final ConcurrentMap<WAL, RollController> wals = new ConcurrentHashMap<WAL, RollController>();
    protected final T abortable;
    private final long rollPeriod;
    private final int threadWakeFrequency;
    private final long checkLowReplicationInterval;
    private volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWAL(final WAL wal) {
        if (this.wals.containsKey(wal)) {
            return;
        }
        AbstractWALRoller abstractWALRoller = this;
        synchronized (abstractWALRoller) {
            if (this.wals.putIfAbsent(wal, new RollController(wal)) == null) {
                wal.registerWALActionsListener(new WALActionsListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void logRollRequested(WALActionsListener.RollRequestReason reason) {
                        AbstractWALRoller abstractWALRoller = AbstractWALRoller.this;
                        synchronized (abstractWALRoller) {
                            RollController controller = AbstractWALRoller.this.wals.computeIfAbsent(wal, rc -> new RollController(wal));
                            controller.requestRoll();
                            AbstractWALRoller.this.notifyAll();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRollAll() {
        AbstractWALRoller abstractWALRoller = this;
        synchronized (abstractWALRoller) {
            for (RollController controller : this.wals.values()) {
                controller.requestRoll();
            }
            this.notifyAll();
        }
    }

    protected AbstractWALRoller(String name, Configuration conf, T abortable) {
        super(name);
        this.abortable = abortable;
        this.rollPeriod = conf.getLong(WAL_ROLL_PERIOD_KEY, 3600000L);
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.checkLowReplicationInterval = conf.getLong("hbase.regionserver.hlog.check.lowreplication.interval", 30000L);
    }

    private void checkLowReplication(long now) {
        try {
            for (Map.Entry entry : this.wals.entrySet()) {
                WAL wal = (WAL)entry.getKey();
                boolean needRollAlready = ((RollController)entry.getValue()).needsRoll(now);
                if (needRollAlready || !(wal instanceof AbstractFSWAL)) continue;
                ((AbstractFSWAL)wal).checkLogLowReplication(this.checkLowReplicationInterval);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed checking low replication", e);
        }
    }

    private void abort(String reason, Throwable cause) {
        for (WAL wal : this.wals.keySet()) {
            try {
                wal.shutdown();
            }
            catch (IOException e) {
                LOG.warn("Failed to shutdown wal", (Throwable)e);
            }
        }
        this.abortable.abort(reason, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            long now = System.currentTimeMillis();
            this.checkLowReplication(now);
            AbstractWALRoller abstractWALRoller = this;
            synchronized (abstractWALRoller) {
                if (this.wals.values().stream().noneMatch(rc -> rc.needsRoll(now))) {
                    try {
                        this.wait(this.threadWakeFrequency);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            try {
                for (Map.Entry entry : this.wals.entrySet()) {
                    WAL wal = (WAL)entry.getKey();
                    RollController controller = (RollController)entry.getValue();
                    if (controller.isRollRequested()) {
                        LOG.debug("WAL {} roll requested", (Object)wal);
                    } else {
                        if (!controller.needsPeriodicRoll(now)) continue;
                        LOG.debug("WAL {} roll period {} ms elapsed", (Object)wal, (Object)this.rollPeriod);
                    }
                    byte[][] regionsToFlush = controller.rollWal(now);
                    if (regionsToFlush != null) {
                        for (byte[] r : regionsToFlush) {
                            this.scheduleFlush(Bytes.toString(r));
                        }
                    }
                    this.afterRoll(wal);
                }
            }
            catch (ConnectException | FailedLogCloseException e) {
                this.abort("Failed log close in log roller", e);
            }
            catch (IOException ex) {
                this.abort("IOE in log roller", ex instanceof RemoteException ? ((RemoteException)((Object)ex)).unwrapRemoteException() : ex);
            }
            catch (Exception ex) {
                LOG.error("Log rolling failed", (Throwable)ex);
                this.abort("Log rolling failed", ex);
            }
        }
        LOG.info("LogRoller exiting.");
    }

    protected void afterRoll(WAL wal) {
    }

    protected abstract void scheduleFlush(String var1);

    private boolean isWaiting() {
        Thread.State state = this.getState();
        return state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING;
    }

    public boolean walRollFinished() {
        return this.wals.values().stream().noneMatch(rc -> rc.needsRoll(System.currentTimeMillis())) && this.isWaiting();
    }

    public void waitUntilWalRollFinished() throws InterruptedException {
        while (!this.walRollFinished()) {
            Thread.sleep(100L);
        }
    }

    @Override
    public void close() {
        this.running = false;
        this.interrupt();
    }

    protected class RollController {
        private final WAL wal;
        private final AtomicBoolean rollRequest;
        private long lastRollTime;

        RollController(WAL wal) {
            this.wal = wal;
            this.rollRequest = new AtomicBoolean(false);
            this.lastRollTime = System.currentTimeMillis();
        }

        public void requestRoll() {
            this.rollRequest.set(true);
        }

        public byte[][] rollWal(long now) throws IOException {
            this.lastRollTime = now;
            this.rollRequest.set(false);
            return this.wal.rollWriter(true);
        }

        public boolean isRollRequested() {
            return this.rollRequest.get();
        }

        public boolean needsPeriodicRoll(long now) {
            return now - this.lastRollTime > AbstractWALRoller.this.rollPeriod;
        }

        public boolean needsRoll(long now) {
            return this.isRollRequested() || this.needsPeriodicRoll(now);
        }
    }
}

