/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.jcodings.Encoding;
import org.apache.hadoop.hbase.shaded.org.jcodings.IntHolder;
import org.apache.hadoop.hbase.shaded.org.joni.Matcher;
import org.apache.hadoop.hbase.shaded.org.joni.Regex;

public abstract class SearchAlgorithm {
    public static final SearchAlgorithm NONE = new SearchAlgorithm(){

        public final String getName() {
            return "NONE";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            return textP;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return textP;
        }
    };
    public static final SearchAlgorithm SLOW = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; s2 += enc.length(text, s2, textEnd)) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_SB";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_IC = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_IC";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            byte[] buf = matcher.icbuf();
            for (int s2 = textP; s2 < end; s2 += enc.length(text, s2, textEnd)) {
                if (!this.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd, enc, buf, regex.caseFoldFlag)) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            byte[] buf = matcher.icbuf();
            while (s2 >= textP) {
                if (this.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd, enc, buf, regex.caseFoldFlag)) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }

        private boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes, int p, int end, Encoding enc, byte[] buf, int caseFoldFlag) {
            IntHolder holder = new IntHolder();
            holder.value = p;
            while (tP < tEnd) {
                int lowlen = enc.mbcCaseFold(caseFoldFlag, bytes, holder, end, buf);
                if (lowlen == 1) {
                    if (t[tP++] == buf[0]) continue;
                    return false;
                }
                int q = 0;
                while (lowlen > 0) {
                    if (t[tP++] != buf[q++]) {
                        return false;
                    }
                    --lowlen;
                }
            }
            return true;
        }
    };
    public static final SearchAlgorithm SLOW_IC_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_IC_SB";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t;
                if (target[targetP] != toLowerTable[text[s2] & 0xFF]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (target[targetP] == toLowerTable[text[s2] & 0xFF]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm BM = new SearchAlgorithm(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        public final String getName() {
            return "EXACT_BM";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            int s2;
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetEnd = regex.exactEnd;
            int targetP = regex.exactP;
            int end = textRange + (targetEnd - targetP) - 1;
            if (end > textEnd) {
                end = textEnd;
            }
            int tail = targetEnd - 1;
            if (regex.intMap == null) {
                for (s2 = textP + (targetEnd - targetP) - 1; s2 < end; s2 += regex.map[text[s2] & 0xFF]) {
                    int p = s2;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                }
            } else {
                while (s2 < end) {
                    int p = s2;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                    s2 += regex.intMap[text[s2] & 0xFF];
                }
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            int s2;
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            if (regex.intMapBackward == null) {
                if (s_ - range_ < 100) {
                    return SLOW.searchBackward(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
                }
                this.setBmBackwardSkip(regex, target, targetP, targetEnd);
            }
            s2 = textStart < (s2 = textEnd - (targetEnd - targetP)) ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                int t;
                int p = s2;
                for (t = targetP; t < targetEnd && text[p] == target[t]; ++t) {
                    ++p;
                }
                if (t == targetEnd) {
                    return s2;
                }
                s2 -= regex.intMapBackward[text[s2] & 0xFF];
                s2 = enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }

        private void setBmBackwardSkip(Regex regex, byte[] bytes, int p, int end) {
            int i;
            int[] skip;
            if (regex.intMapBackward == null) {
                skip = new int[256];
                regex.intMapBackward = skip;
            } else {
                skip = regex.intMapBackward;
            }
            int len = end - p;
            for (i = 0; i < 256; ++i) {
                skip[i] = len;
            }
            for (i = len - 1; i > 0; --i) {
                skip[bytes[i] & 0xFF] = i;
            }
        }
    };
    public static final SearchAlgorithm BM_NOT_REV = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_BM_NOT_REV";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int end = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s2 = textP;
            if (regex.intMap == null) {
                while (s2 < end) {
                    int se;
                    int p = se = s2 + tlen1;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return s2;
                        }
                        --p;
                        --t;
                    }
                    byte skip = regex.map[text[se] & 0xFF];
                    t = s2;
                    while ((s2 += enc.length(text, s2, textEnd)) - t < skip && s2 < end) {
                    }
                }
            } else {
                while (s2 < end) {
                    int se;
                    int p = se = s2 + tlen1;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return s2;
                        }
                        --p;
                        --t;
                    }
                    int skip = regex.intMap[text[se] & 0xFF];
                    t = s2;
                    while ((s2 += enc.length(text, s2, textEnd)) - t < skip && s2 < end) {
                    }
                }
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return BM.searchBackward(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
        }
    };
    public static final SearchAlgorithm MAP = new SearchAlgorithm(){

        public final String getName() {
            return "MAP";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; s2 += enc.length(text, s2, textEnd)) {
                if (map[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm MAP_SB = new SearchAlgorithm(){

        public final String getName() {
            return "MAP_SB";
        }

        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; ++s2) {
                if (map[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                --s2;
            }
            return -1;
        }
    };

    public abstract String getName();

    public abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5);

    public abstract int searchBackward(Matcher var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

