/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private String keyPrefix;
    @Deprecated
    private final String shippedKBsKey;
    private final String shippedBytesKey;
    private final String logReadInBytesKey;
    private final String shippedHFilesKey;
    private final String sizeOfHFileRefsQueueKey;
    private final MutableHistogram ageOfLastShippedOpHist;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableFastCounter logReadInEditsCounter;
    private final MutableFastCounter walEditsFilteredCounter;
    private final MutableFastCounter shippedBatchesCounter;
    private final MutableFastCounter shippedOpsCounter;
    private final MutableFastCounter shippedKBsCounter;
    private final MutableFastCounter shippedBytesCounter;
    private final MutableFastCounter logReadInBytesCounter;
    private final MutableFastCounter shippedHFilesCounter;
    private final MutableGaugeLong sizeOfHFileRefsQueueGauge;
    private final String unknownFileLengthKey;
    private final String uncleanlyClosedKey;
    private final String uncleanlySkippedBytesKey;
    private final String restartedKey;
    private final String repeatedBytesKey;
    private final String completedLogsKey;
    private final String completedRecoveryKey;
    private final MutableFastCounter unknownFileLengthForClosedWAL;
    private final MutableFastCounter uncleanlyClosedWAL;
    private final MutableFastCounter uncleanlyClosedSkippedBytes;
    private final MutableFastCounter restartWALReading;
    private final MutableFastCounter repeatedFileBytes;
    private final MutableFastCounter completedWAL;
    private final MutableFastCounter completedRecoveryQueue;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.keyPrefix = "source." + this.id + ".";
        this.ageOfLastShippedOpKey = this.keyPrefix + "ageOfLastShippedOp";
        this.ageOfLastShippedOpHist = rms.getMetricsRegistry().getHistogram(this.ageOfLastShippedOpKey);
        this.sizeOfLogQueueKey = this.keyPrefix + "sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = this.keyPrefix + "shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = this.keyPrefix + "shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = this.keyPrefix + "shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getCounter(this.shippedKBsKey, 0L);
        this.shippedBytesKey = this.keyPrefix + "shippedBytes";
        this.shippedBytesCounter = rms.getMetricsRegistry().getCounter(this.shippedBytesKey, 0L);
        this.logReadInBytesKey = this.keyPrefix + "logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = this.keyPrefix + "logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = this.keyPrefix + "logEditsFiltered";
        this.walEditsFilteredCounter = rms.getMetricsRegistry().getCounter(this.logEditsFilteredKey, 0L);
        this.shippedHFilesKey = this.keyPrefix + "shippedHFiles";
        this.shippedHFilesCounter = rms.getMetricsRegistry().getCounter(this.shippedHFilesKey, 0L);
        this.sizeOfHFileRefsQueueKey = this.keyPrefix + "sizeOfHFileRefsQueue";
        this.sizeOfHFileRefsQueueGauge = rms.getMetricsRegistry().getGauge(this.sizeOfHFileRefsQueueKey, 0L);
        this.unknownFileLengthKey = this.keyPrefix + "closedLogsWithUnknownFileLength";
        this.unknownFileLengthForClosedWAL = rms.getMetricsRegistry().getCounter(this.unknownFileLengthKey, 0L);
        this.uncleanlyClosedKey = this.keyPrefix + "uncleanlyClosedLogs";
        this.uncleanlyClosedWAL = rms.getMetricsRegistry().getCounter(this.uncleanlyClosedKey, 0L);
        this.uncleanlySkippedBytesKey = this.keyPrefix + "ignoredUncleanlyClosedLogContentsInBytes";
        this.uncleanlyClosedSkippedBytes = rms.getMetricsRegistry().getCounter(this.uncleanlySkippedBytesKey, 0L);
        this.restartedKey = this.keyPrefix + "restartedLogReading";
        this.restartWALReading = rms.getMetricsRegistry().getCounter(this.restartedKey, 0L);
        this.repeatedBytesKey = this.keyPrefix + "repeatedLogFileBytes";
        this.repeatedFileBytes = rms.getMetricsRegistry().getCounter(this.repeatedBytesKey, 0L);
        this.completedLogsKey = this.keyPrefix + "completedLogs";
        this.completedWAL = rms.getMetricsRegistry().getCounter(this.completedLogsKey, 0L);
        this.completedRecoveryKey = this.keyPrefix + "completedRecoverQueues";
        this.completedRecoveryQueue = rms.getMetricsRegistry().getCounter(this.completedRecoveryKey, 0L);
    }

    @Override
    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpHist.add(age);
    }

    @Override
    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    @Override
    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    @Override
    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    @Override
    public void incrLogEditsFiltered(long size) {
        this.walEditsFilteredCounter.incr(size);
    }

    @Override
    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    @Override
    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    @Override
    public void incrShippedBytes(long size) {
        this.shippedBytesCounter.incr(size);
        MetricsReplicationGlobalSourceSource.incrementKBsCounter(this.shippedBytesCounter, this.shippedKBsCounter);
    }

    @Override
    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    @Override
    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.shippedBytesKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
        this.rms.removeMetric(this.shippedHFilesKey);
        this.rms.removeMetric(this.sizeOfHFileRefsQueueKey);
        this.rms.removeMetric(this.unknownFileLengthKey);
        this.rms.removeMetric(this.uncleanlyClosedKey);
        this.rms.removeMetric(this.uncleanlySkippedBytesKey);
        this.rms.removeMetric(this.restartedKey);
        this.rms.removeMetric(this.repeatedBytesKey);
        this.rms.removeMetric(this.completedLogsKey);
        this.rms.removeMetric(this.completedRecoveryKey);
    }

    @Override
    public long getLastShippedAge() {
        return this.ageOfLastShippedOpHist.getMax();
    }

    @Override
    public void incrHFilesShipped(long hfiles) {
        this.shippedHFilesCounter.incr(hfiles);
    }

    @Override
    public void incrSizeOfHFileRefsQueue(long size) {
        this.sizeOfHFileRefsQueueGauge.incr(size);
    }

    @Override
    public void decrSizeOfHFileRefsQueue(long size) {
        this.sizeOfHFileRefsQueueGauge.decr(size);
    }

    @Override
    public int getSizeOfLogQueue() {
        return (int)this.sizeOfLogQueueGauge.value();
    }

    @Override
    public void incrUnknownFileLengthForClosedWAL() {
        this.unknownFileLengthForClosedWAL.incr(1L);
    }

    @Override
    public void incrUncleanlyClosedWALs() {
        this.uncleanlyClosedWAL.incr(1L);
    }

    @Override
    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.uncleanlyClosedSkippedBytes.incr(bytes);
    }

    @Override
    public void incrRestartedWALReading() {
        this.restartWALReading.incr(1L);
    }

    @Override
    public void incrRepeatedFileBytes(long bytes) {
        this.repeatedFileBytes.incr(bytes);
    }

    @Override
    public void incrCompletedWAL() {
        this.completedWAL.incr(1L);
    }

    @Override
    public void incrCompletedRecoveryQueue() {
        this.completedRecoveryQueue.incr(1L);
    }

    @Override
    public void incrFailedRecoveryQueue() {
    }

    @Override
    public void init() {
        this.rms.init();
    }

    @Override
    public void setGauge(String gaugeName, long value) {
        this.rms.setGauge(this.keyPrefix + gaugeName, value);
    }

    @Override
    public void incGauge(String gaugeName, long delta) {
        this.rms.incGauge(this.keyPrefix + gaugeName, delta);
    }

    @Override
    public void decGauge(String gaugeName, long delta) {
        this.rms.decGauge(this.keyPrefix + gaugeName, delta);
    }

    @Override
    public void removeMetric(String key) {
        this.rms.removeMetric(this.keyPrefix + key);
    }

    @Override
    public void incCounters(String counterName, long delta) {
        this.rms.incCounters(this.keyPrefix + counterName, delta);
    }

    @Override
    public void updateHistogram(String name, long value) {
        this.rms.updateHistogram(this.keyPrefix + name, value);
    }

    @Override
    public String getMetricsContext() {
        return this.rms.getMetricsContext();
    }

    @Override
    public String getMetricsDescription() {
        return this.rms.getMetricsDescription();
    }

    @Override
    public String getMetricsJmxContext() {
        return this.rms.getMetricsJmxContext();
    }

    @Override
    public String getMetricsName() {
        return this.rms.getMetricsName();
    }

    @Override
    public long getWALEditsRead() {
        return this.logReadInEditsCounter.value();
    }

    @Override
    public long getShippedOps() {
        return this.shippedOpsCounter.value();
    }

    @Override
    public long getEditsFiltered() {
        return this.walEditsFilteredCounter.value();
    }
}

