/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ByteBuff {
    private static final int NIO_BUFFER_LIMIT = 65536;

    public abstract int position();

    public abstract ByteBuff position(int var1);

    public abstract ByteBuff skip(int var1);

    public abstract ByteBuff moveBack(int var1);

    public abstract int capacity();

    public abstract int limit();

    public abstract ByteBuff limit(int var1);

    public abstract ByteBuff rewind();

    public abstract ByteBuff mark();

    public abstract ByteBuffer asSubByteBuffer(int var1);

    public abstract void asSubByteBuffer(int var1, int var2, ObjectIntPair<ByteBuffer> var3);

    public abstract int remaining();

    public abstract boolean hasRemaining();

    public abstract ByteBuff reset();

    public abstract ByteBuff slice();

    public abstract ByteBuff duplicate();

    public abstract byte get();

    public abstract byte get(int var1);

    public abstract byte getByteAfterPosition(int var1);

    public abstract ByteBuff put(byte var1);

    public abstract ByteBuff put(int var1, byte var2);

    public abstract void get(byte[] var1, int var2, int var3);

    public abstract void get(int var1, byte[] var2, int var3, int var4);

    public abstract void get(byte[] var1);

    public abstract ByteBuff put(byte[] var1, int var2, int var3);

    public abstract ByteBuff put(byte[] var1);

    public abstract boolean hasArray();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract short getShort();

    public abstract short getShort(int var1);

    public abstract short getShortAfterPosition(int var1);

    public abstract int getInt();

    public abstract ByteBuff putInt(int var1);

    public abstract int getInt(int var1);

    public abstract int getIntAfterPosition(int var1);

    public abstract long getLong();

    public abstract ByteBuff putLong(long var1);

    public abstract long getLong(int var1);

    public abstract long getLongAfterPosition(int var1);

    public byte[] toBytes() {
        return this.toBytes(0, this.limit());
    }

    public abstract byte[] toBytes(int var1, int var2);

    public abstract void get(ByteBuffer var1, int var2, int var3);

    public abstract ByteBuff put(int var1, ByteBuff var2, int var3, int var4);

    public abstract int read(ReadableByteChannel var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int channelRead(ReadableByteChannel channel, ByteBuffer buf) throws IOException {
        int nBytes;
        if (buf.remaining() <= 65536) {
            return channel.read(buf);
        }
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), 65536);
                buf.limit(buf.position() + ioSize);
                ret = channel.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    public static int readCompressedInt(ByteBuff buf) {
        byte b = buf.get();
        if ((b & 0x80) != 0) {
            return (b & 0x7F) + (ByteBuff.readCompressedInt(buf) << 7);
        }
        return b & 0x7F;
    }

    public static int compareTo(ByteBuff buf1, int o1, int len1, ByteBuff buf2, int o2, int len2) {
        if (buf1.hasArray() && buf2.hasArray()) {
            return Bytes.compareTo(buf1.array(), buf1.arrayOffset() + o1, len1, buf2.array(), buf2.arrayOffset() + o2, len2);
        }
        int end1 = o1 + len1;
        int end2 = o2 + len2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int b;
            int a = buf1.get(i) & 0xFF;
            if (a == (b = buf2.get(j) & 0xFF)) continue;
            return a - b;
        }
        return len1 - len2;
    }

    public static long readLong(ByteBuff in, int fitInBytes) {
        long tmpLength = 0L;
        for (int i = 0; i < fitInBytes; ++i) {
            tmpLength |= ((long)in.get() & 0xFFL) << (int)(8L * (long)i);
        }
        return tmpLength;
    }

    public static long readVLong(ByteBuff in) {
        byte firstByte = in.get();
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = in.get();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int unsignedBinarySearch(ByteBuff a, int fromIndex, int toIndex, byte key) {
        int unsignedKey = key & 0xFF;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            int midVal = a.get(mid) & 0xFF;
            if (midVal < unsignedKey) {
                low = mid + 1;
                continue;
            }
            if (midVal > unsignedKey) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pos=" + this.position() + ", lim=" + this.limit() + ", cap= " + this.capacity() + "]";
    }

    public static String toStringBinary(ByteBuff b, int off, int len) {
        StringBuilder result = new StringBuilder();
        if (off >= b.capacity()) {
            return result.toString();
        }
        if (off + len > b.capacity()) {
            len = b.capacity() - off;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = b.get(i) & 0xFF;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
                result.append((char)ch);
                continue;
            }
            result.append(String.format("\\x%02X", ch));
        }
        return result.toString();
    }
}

