/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class GCMultipleMergedRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.GCMergedRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(GCMultipleMergedRegionsProcedure.class);
    private List<RegionInfo> parents;
    private RegionInfo mergedChild;

    public GCMultipleMergedRegionsProcedure(MasterProcedureEnv env, RegionInfo mergedChild, List<RegionInfo> parents) {
        super(env);
        this.parents = parents;
        this.mergedChild = mergedChild;
    }

    public GCMultipleMergedRegionsProcedure() {
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.MERGED_REGIONS_GC;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.GCMergedRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        try {
            switch (state) {
                case GC_MERGED_REGIONS_PREPARE: {
                    List<RegionInfo> parents = MetaTableAccessor.getMergeRegions(env.getMasterServices().getConnection(), this.mergedChild.getRegionName());
                    if (parents == null || parents.isEmpty()) {
                        LOG.info("{} mergeXXX qualifiers have ALL been deleted", (Object)this.mergedChild.getShortNameToLog());
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.GCMergedRegionsState.GC_MERGED_REGIONS_PURGE);
                    break;
                }
                case GC_MERGED_REGIONS_PURGE: {
                    this.addChildProcedure(this.createGCRegionProcedures(env));
                    this.setNextState(MasterProcedureProtos.GCMergedRegionsState.GC_REGION_EDIT_METADATA);
                    break;
                }
                case GC_REGION_EDIT_METADATA: {
                    MetaTableAccessor.deleteMergeQualifiers(env.getMasterServices().getConnection(), this.mergedChild);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error trying to GC merged regions {}; retrying...", (Object)this.parents.stream().map(r -> RegionInfo.getShortNameToLog(r)).collect(Collectors.joining(", ")), (Object)ioe);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private GCRegionProcedure[] createGCRegionProcedures(MasterProcedureEnv env) {
        GCRegionProcedure[] procs = new GCRegionProcedure[this.parents.size()];
        int index = 0;
        for (RegionInfo ri : this.parents) {
            GCRegionProcedure proc = new GCRegionProcedure(env, ri);
            proc.setOwner(env.getRequestUser().getShortName());
            procs[index++] = proc;
        }
        return procs;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.GCMergedRegionsState state) throws IOException, InterruptedException {
    }

    @Override
    protected MasterProcedureProtos.GCMergedRegionsState getState(int stateId) {
        return MasterProcedureProtos.GCMergedRegionsState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.GCMergedRegionsState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.GCMergedRegionsState getInitialState() {
        return MasterProcedureProtos.GCMergedRegionsState.GC_MERGED_REGIONS_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.GCMultipleMergedRegionsStateData.Builder msg = MasterProcedureProtos.GCMultipleMergedRegionsStateData.newBuilder().addAllParents(this.parents.stream().map(ProtobufUtil::toRegionInfo).collect(Collectors.toList())).setMergedChild(ProtobufUtil.toRegionInfo(this.mergedChild));
        serializer.serialize(msg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.GCMultipleMergedRegionsStateData msg = serializer.deserialize(MasterProcedureProtos.GCMultipleMergedRegionsStateData.class);
        this.parents = msg.getParentsList().stream().map(ProtobufUtil::toRegionInfo).collect(Collectors.toList());
        this.mergedChild = ProtobufUtil.toRegionInfo(msg.getMergedChild());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" child=");
        sb.append(this.mergedChild.getShortNameToLog());
        sb.append(", parents:");
        sb.append(this.parents.stream().map(r -> RegionInfo.getShortNameToLog(r)).collect(Collectors.joining(", ")));
    }

    @Override
    public TableName getTableName() {
        return this.mergedChild.getTable();
    }
}

