/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class EntryBuffers {
    private static final Logger LOG = LoggerFactory.getLogger(EntryBuffers.class);
    WALSplitter.PipelineController controller;
    Map<byte[], WALSplitter.RegionEntryBuffer> buffers = new TreeMap<byte[], WALSplitter.RegionEntryBuffer>(Bytes.BYTES_COMPARATOR);
    Set<byte[]> currentlyWriting = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
    long totalBuffered = 0L;
    long maxHeapUsage;
    boolean splitWriterCreationBounded;

    public EntryBuffers(WALSplitter.PipelineController controller, long maxHeapUsage) {
        this(controller, maxHeapUsage, false);
    }

    public EntryBuffers(WALSplitter.PipelineController controller, long maxHeapUsage, boolean splitWriterCreationBounded) {
        this.controller = controller;
        this.maxHeapUsage = maxHeapUsage;
        this.splitWriterCreationBounded = splitWriterCreationBounded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendEntry(WAL.Entry entry) throws InterruptedException, IOException {
        long incrHeap;
        WALKeyImpl key = entry.getKey();
        Object object = this;
        synchronized (object) {
            WALSplitter.RegionEntryBuffer buffer = this.buffers.get(key.getEncodedRegionName());
            if (buffer == null) {
                buffer = new WALSplitter.RegionEntryBuffer(key.getTableName(), key.getEncodedRegionName());
                this.buffers.put(key.getEncodedRegionName(), buffer);
            }
            incrHeap = buffer.appendEntry(entry);
        }
        object = this.controller.dataAvailable;
        synchronized (object) {
            this.totalBuffered += incrHeap;
            while (this.totalBuffered > this.maxHeapUsage && this.controller.thrown.get() == null) {
                LOG.debug("Used {} bytes of buffered edits, waiting for IO threads", (Object)this.totalBuffered);
                this.controller.dataAvailable.wait(2000L);
            }
            this.controller.dataAvailable.notifyAll();
        }
        this.controller.checkForErrors();
    }

    synchronized WALSplitter.RegionEntryBuffer getChunkToWrite() {
        if (this.splitWriterCreationBounded && this.totalBuffered < this.maxHeapUsage) {
            return null;
        }
        long biggestSize = 0L;
        byte[] biggestBufferKey = null;
        for (Map.Entry<byte[], WALSplitter.RegionEntryBuffer> entry : this.buffers.entrySet()) {
            long size = entry.getValue().heapSize();
            if (size <= biggestSize || this.currentlyWriting.contains(entry.getKey())) continue;
            biggestSize = size;
            biggestBufferKey = entry.getKey();
        }
        if (biggestBufferKey == null) {
            return null;
        }
        WALSplitter.RegionEntryBuffer buffer = this.buffers.remove(biggestBufferKey);
        this.currentlyWriting.add(biggestBufferKey);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneWriting(WALSplitter.RegionEntryBuffer buffer) {
        EntryBuffers entryBuffers = this;
        synchronized (entryBuffers) {
            boolean removed = this.currentlyWriting.remove(buffer.encodedRegionName);
            assert (removed);
        }
        long size = buffer.heapSize();
        Object object = this.controller.dataAvailable;
        synchronized (object) {
            this.totalBuffered -= size;
            this.controller.dataAvailable.notifyAll();
        }
    }

    synchronized boolean isRegionCurrentlyWriting(byte[] region) {
        return this.currentlyWriting.contains(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDrained() {
        Object object = this.controller.dataAvailable;
        synchronized (object) {
            while (this.totalBuffered > 0L) {
                try {
                    this.controller.dataAvailable.wait(2000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted while waiting for EntryBuffers is drained");
                    Thread.interrupted();
                    break;
                }
            }
        }
    }
}

