/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.token.Token;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TokenUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TokenUtil.class);
    private static ServiceException injectedException;

    private static void injectFault() throws ServiceException {
        if (injectedException != null) {
            throw injectedException;
        }
    }

    @Deprecated
    public static Token<AuthenticationTokenIdentifier> obtainToken(Configuration conf) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(connection);
            return token;
        }
    }

    public static Token<AuthenticationTokenIdentifier> obtainToken(Connection conn) throws IOException {
        try (Table meta = null;){
            TokenUtil.injectFault();
            meta = conn.getTable(TableName.META_TABLE_NAME);
            CoprocessorRpcChannel rpcChannel = meta.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub(rpcChannel);
            AuthenticationProtos.GetAuthenticationTokenResponse response = service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            Token<AuthenticationTokenIdentifier> token = TokenUtil.toToken(response.getToken());
            return token;
        }
    }

    public static AuthenticationProtos.Token toToken(Token<AuthenticationTokenIdentifier> token) {
        AuthenticationProtos.Token.Builder builder = AuthenticationProtos.Token.newBuilder();
        builder.setIdentifier(ByteString.copyFrom(token.getIdentifier()));
        builder.setPassword(ByteString.copyFrom(token.getPassword()));
        if (token.getService() != null) {
            builder.setService(ByteString.copyFromUtf8(token.getService().toString()));
        }
        return builder.build();
    }

    public static Token<AuthenticationTokenIdentifier> obtainToken(final Connection conn, User user) throws IOException, InterruptedException {
        return user.runAs(new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

            @Override
            public Token<AuthenticationTokenIdentifier> run() throws Exception {
                return TokenUtil.obtainToken(conn);
            }
        });
    }

    private static Text getClusterId(Token<AuthenticationTokenIdentifier> token) throws IOException {
        return token.getService() != null ? token.getService() : new Text("default");
    }

    public static void obtainAndCacheToken(Connection conn, User user) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName());
            }
            user.addToken(token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    public static void obtainTokenForJob(Connection conn, User user, Job job) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            Text clusterId = TokenUtil.getClusterId(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName() + " on cluster " + clusterId.toString());
            }
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    public static void obtainTokenForJob(Connection conn, JobConf job, User user) throws IOException, InterruptedException {
        try {
            Token<AuthenticationTokenIdentifier> token = TokenUtil.obtainToken(conn, user);
            if (token == null) {
                throw new IOException("No token returned for user " + user.getName());
            }
            Text clusterId = TokenUtil.getClusterId(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained token " + token.getKind().toString() + " for user " + user.getName() + " on cluster " + clusterId.toString());
            }
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getName());
        }
    }

    public static void addTokenForJob(Connection conn, JobConf job, User user) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = TokenUtil.obtainToken(conn, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static void addTokenForJob(Connection conn, User user, Job job) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = TokenUtil.obtainToken(conn, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static boolean addTokenIfMissing(Connection conn, User user) throws IOException, InterruptedException {
        Token<AuthenticationTokenIdentifier> token = TokenUtil.getAuthToken(conn.getConfiguration(), user);
        if (token == null) {
            token = TokenUtil.obtainToken(conn, user);
            user.getUGI().addToken(token.getService(), token);
            return true;
        }
        return false;
    }

    private static Token<AuthenticationTokenIdentifier> getAuthToken(Configuration conf, User user) throws IOException, InterruptedException {
        try (ZKWatcher zkw = new ZKWatcher(conf, "TokenUtil-getAuthToken", null);){
            String clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (clusterId == null) {
                throw new IOException("Failed to get cluster ID");
            }
            Token<AuthenticationTokenIdentifier> token = new AuthenticationTokenSelector().selectToken(new Text(clusterId), user.getTokens());
            return token;
        }
    }

    public static Token<AuthenticationTokenIdentifier> toToken(AuthenticationProtos.Token proto) {
        return new Token(proto.hasIdentifier() ? proto.getIdentifier().toByteArray() : null, proto.hasPassword() ? proto.getPassword().toByteArray() : null, AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE, proto.hasService() ? new Text(proto.getService().toStringUtf8()) : null);
    }
}

