/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MetricsRegionServerWrapperImpl
implements MetricsRegionServerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsRegionServerWrapperImpl.class);
    private final HRegionServer regionServer;
    private final MetricsWALSource metricsWALSource;
    private Optional<BlockCache> blockCache;
    private Optional<MobFileCache> mobFileCache;
    private Optional<CacheStats> cacheStats;
    private Optional<CacheStats> l1Stats = Optional.empty();
    private Optional<CacheStats> l2Stats = Optional.empty();
    private volatile long numStores = 0L;
    private volatile long numWALFiles = 0L;
    private volatile long walFileSize = 0L;
    private volatile long numStoreFiles = 0L;
    private volatile long memstoreSize = 0L;
    private volatile long storeFileSize = 0L;
    private volatile long maxStoreFileAge = 0L;
    private volatile long minStoreFileAge = 0L;
    private volatile long avgStoreFileAge = 0L;
    private volatile long numReferenceFiles = 0L;
    private volatile double requestsPerSecond = 0.0;
    private volatile long readRequestsCount = 0L;
    private volatile double readRequestsRatePerSecond = 0.0;
    private volatile long filteredReadRequestsCount = 0L;
    private volatile long writeRequestsCount = 0L;
    private volatile double writeRequestsRatePerSecond = 0.0;
    private volatile long checkAndMutateChecksFailed = 0L;
    private volatile long checkAndMutateChecksPassed = 0L;
    private volatile long storefileIndexSize = 0L;
    private volatile long totalStaticIndexSize = 0L;
    private volatile long totalStaticBloomSize = 0L;
    private volatile long numMutationsWithoutWAL = 0L;
    private volatile long dataInMemoryWithoutWAL = 0L;
    private volatile double percentFileLocal = 0.0;
    private volatile double percentFileLocalSecondaryRegions = 0.0;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    private volatile long cellsCountCompactedToMob = 0L;
    private volatile long cellsCountCompactedFromMob = 0L;
    private volatile long cellsSizeCompactedToMob = 0L;
    private volatile long cellsSizeCompactedFromMob = 0L;
    private volatile long mobFlushCount = 0L;
    private volatile long mobFlushedCellsCount = 0L;
    private volatile long mobFlushedCellsSize = 0L;
    private volatile long mobScanCellsCount = 0L;
    private volatile long mobScanCellsSize = 0L;
    private volatile long mobFileCacheAccessCount = 0L;
    private volatile long mobFileCacheMissCount = 0L;
    private volatile double mobFileCacheHitRatio = 0.0;
    private volatile long mobFileCacheEvictedCount = 0L;
    private volatile long mobFileCacheCount = 0L;
    private volatile long blockedRequestsCount = 0L;
    private volatile long averageRegionSize = 0L;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;
    private DFSHedgedReadMetrics dfsHedgedReadMetrics;

    public MetricsRegionServerWrapperImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.initBlockCache();
        this.initMobFileCache();
        this.period = regionServer.conf.getLong("hbase.regionserver.metrics.period", 5000L);
        this.executor = CompatibilitySingletonFactory.getInstance(MetricsExecutor.class).getExecutor();
        this.runnable = new RegionServerMetricsWrapperRunnable();
        this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
        this.metricsWALSource = CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        try {
            this.dfsHedgedReadMetrics = FSUtils.getDFSHedgedReadMetrics(regionServer.getConfiguration());
        }
        catch (IOException e) {
            LOG.warn("Failed to get hedged metrics", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Computing regionserver metrics every " + this.period + " milliseconds");
        }
    }

    private void initBlockCache() {
        this.blockCache = this.regionServer.getBlockCache();
        this.cacheStats = this.blockCache.map(BlockCache::getStats);
        if (this.cacheStats.isPresent()) {
            if (this.cacheStats.get() instanceof CombinedBlockCache.CombinedCacheStats) {
                this.l1Stats = Optional.of(((CombinedBlockCache.CombinedCacheStats)this.cacheStats.get()).getLruCacheStats());
                this.l2Stats = Optional.of(((CombinedBlockCache.CombinedCacheStats)this.cacheStats.get()).getBucketCacheStats());
            } else {
                this.l1Stats = this.cacheStats;
            }
        }
    }

    private void initMobFileCache() {
        this.mobFileCache = this.regionServer.getMobFileCache();
    }

    @Override
    public String getClusterId() {
        return this.regionServer.getClusterId();
    }

    @Override
    public long getStartCode() {
        return this.regionServer.getStartcode();
    }

    @Override
    public String getZookeeperQuorum() {
        ZKWatcher zk = this.regionServer.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    @Override
    public String getCoprocessors() {
        Object[] coprocessors = this.regionServer.getRegionServerCoprocessors();
        if (coprocessors == null || coprocessors.length == 0) {
            return "";
        }
        return StringUtils.join(coprocessors, ", ");
    }

    @Override
    public String getServerName() {
        ServerName serverName = this.regionServer.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    @Override
    public long getNumOnlineRegions() {
        Collection<HRegion> onlineRegionsLocalContext = this.regionServer.getOnlineRegionsLocalContext();
        if (onlineRegionsLocalContext == null) {
            return 0L;
        }
        return onlineRegionsLocalContext.size();
    }

    @Override
    public long getTotalRequestCount() {
        return this.regionServer.rpcServices.requestCount.sum();
    }

    @Override
    public long getTotalRowActionRequestCount() {
        return this.readRequestsCount + this.writeRequestsCount;
    }

    @Override
    public int getSplitQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSplitQueueSize();
    }

    @Override
    public int getCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getCompactionQueueSize();
    }

    @Override
    public int getSmallCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSmallCompactionQueueSize();
    }

    @Override
    public int getLargeCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getLargeCompactionQueueSize();
    }

    @Override
    public int getFlushQueueSize() {
        if (this.regionServer.cacheFlusher == null) {
            return 0;
        }
        return this.regionServer.cacheFlusher.getFlushQueueSize();
    }

    @Override
    public long getBlockCacheCount() {
        return this.blockCache.map(BlockCache::getBlockCount).orElse(0L);
    }

    @Override
    public long getMemStoreLimit() {
        return this.regionServer.getRegionServerAccounting().getGlobalMemStoreLimit();
    }

    @Override
    public long getBlockCacheSize() {
        return this.blockCache.map(BlockCache::getCurrentSize).orElse(0L);
    }

    @Override
    public long getBlockCacheFreeSize() {
        return this.blockCache.map(BlockCache::getFreeSize).orElse(0L);
    }

    @Override
    public long getBlockCacheHitCount() {
        return this.cacheStats.map(CacheStats::getHitCount).orElse(0L);
    }

    @Override
    public long getBlockCachePrimaryHitCount() {
        return this.cacheStats.map(CacheStats::getPrimaryHitCount).orElse(0L);
    }

    @Override
    public long getBlockCacheMissCount() {
        return this.cacheStats.map(CacheStats::getMissCount).orElse(0L);
    }

    @Override
    public long getBlockCachePrimaryMissCount() {
        return this.cacheStats.map(CacheStats::getPrimaryMissCount).orElse(0L);
    }

    @Override
    public long getBlockCacheEvictedCount() {
        return this.cacheStats.map(CacheStats::getEvictedCount).orElse(0L);
    }

    @Override
    public long getBlockCachePrimaryEvictedCount() {
        return this.cacheStats.map(CacheStats::getPrimaryEvictedCount).orElse(0L);
    }

    @Override
    public double getBlockCacheHitPercent() {
        double ratio = this.cacheStats.map(CacheStats::getHitRatio).orElse(0.0);
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    @Override
    public double getBlockCacheHitCachingPercent() {
        double ratio = this.cacheStats.map(CacheStats::getHitCachingRatio).orElse(0.0);
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    @Override
    public long getBlockCacheFailedInsertions() {
        return this.cacheStats.map(CacheStats::getFailedInserts).orElse(0L);
    }

    @Override
    public long getL1CacheHitCount() {
        return this.l1Stats.map(CacheStats::getHitCount).orElse(0L);
    }

    @Override
    public long getL1CacheMissCount() {
        return this.l1Stats.map(CacheStats::getMissCount).orElse(0L);
    }

    @Override
    public double getL1CacheHitRatio() {
        return this.l1Stats.map(CacheStats::getHitRatio).orElse(0.0);
    }

    @Override
    public double getL1CacheMissRatio() {
        return this.l1Stats.map(CacheStats::getMissRatio).orElse(0.0);
    }

    @Override
    public long getL2CacheHitCount() {
        return this.l2Stats.map(CacheStats::getHitCount).orElse(0L);
    }

    @Override
    public long getL2CacheMissCount() {
        return this.l2Stats.map(CacheStats::getMissCount).orElse(0L);
    }

    @Override
    public double getL2CacheHitRatio() {
        return this.l2Stats.map(CacheStats::getHitRatio).orElse(0.0);
    }

    @Override
    public double getL2CacheMissRatio() {
        return this.l2Stats.map(CacheStats::getMissRatio).orElse(0.0);
    }

    @Override
    public void forceRecompute() {
        this.runnable.run();
    }

    @Override
    public long getNumStores() {
        return this.numStores;
    }

    @Override
    public long getNumWALFiles() {
        return this.numWALFiles;
    }

    @Override
    public long getWALFileSize() {
        return this.walFileSize;
    }

    @Override
    public long getNumWALSlowAppend() {
        return this.metricsWALSource.getSlowAppendCount();
    }

    @Override
    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    @Override
    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    @Override
    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    @Override
    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    @Override
    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    @Override
    public long getMemStoreSize() {
        return this.memstoreSize;
    }

    @Override
    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    @Override
    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Override
    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    @Override
    public double getReadRequestsRatePerSecond() {
        return this.readRequestsRatePerSecond;
    }

    @Override
    public long getFilteredReadRequestsCount() {
        return this.filteredReadRequestsCount;
    }

    @Override
    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    @Override
    public double getWriteRequestsRatePerSecond() {
        return this.writeRequestsRatePerSecond;
    }

    @Override
    public long getRpcGetRequestsCount() {
        return this.regionServer.rpcServices.rpcGetRequestCount.sum();
    }

    @Override
    public long getRpcScanRequestsCount() {
        return this.regionServer.rpcServices.rpcScanRequestCount.sum();
    }

    @Override
    public long getRpcMultiRequestsCount() {
        return this.regionServer.rpcServices.rpcMultiRequestCount.sum();
    }

    @Override
    public long getRpcMutateRequestsCount() {
        return this.regionServer.rpcServices.rpcMutateRequestCount.sum();
    }

    @Override
    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed;
    }

    @Override
    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed;
    }

    @Override
    public long getStoreFileIndexSize() {
        return this.storefileIndexSize;
    }

    @Override
    public long getTotalStaticIndexSize() {
        return this.totalStaticIndexSize;
    }

    @Override
    public long getTotalStaticBloomSize() {
        return this.totalStaticBloomSize;
    }

    @Override
    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL;
    }

    @Override
    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL;
    }

    @Override
    public double getPercentFileLocal() {
        return this.percentFileLocal;
    }

    @Override
    public double getPercentFileLocalSecondaryRegions() {
        return this.percentFileLocalSecondaryRegions;
    }

    @Override
    public long getUpdatesBlockedTime() {
        if (this.regionServer.cacheFlusher == null) {
            return 0L;
        }
        return this.regionServer.cacheFlusher.getUpdatesBlockedMsHighWater().sum();
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    @Override
    public long getCellsCountCompactedFromMob() {
        return this.cellsCountCompactedFromMob;
    }

    @Override
    public long getCellsCountCompactedToMob() {
        return this.cellsCountCompactedToMob;
    }

    @Override
    public long getCellsSizeCompactedFromMob() {
        return this.cellsSizeCompactedFromMob;
    }

    @Override
    public long getCellsSizeCompactedToMob() {
        return this.cellsSizeCompactedToMob;
    }

    @Override
    public long getMobFlushCount() {
        return this.mobFlushCount;
    }

    @Override
    public long getMobFlushedCellsCount() {
        return this.mobFlushedCellsCount;
    }

    @Override
    public long getMobFlushedCellsSize() {
        return this.mobFlushedCellsSize;
    }

    @Override
    public long getMobScanCellsCount() {
        return this.mobScanCellsCount;
    }

    @Override
    public long getMobScanCellsSize() {
        return this.mobScanCellsSize;
    }

    @Override
    public long getMobFileCacheAccessCount() {
        return this.mobFileCacheAccessCount;
    }

    @Override
    public long getMobFileCacheMissCount() {
        return this.mobFileCacheMissCount;
    }

    @Override
    public long getMobFileCacheCount() {
        return this.mobFileCacheCount;
    }

    @Override
    public long getMobFileCacheEvictedCount() {
        return this.mobFileCacheEvictedCount;
    }

    @Override
    public double getMobFileCacheHitPercent() {
        return this.mobFileCacheHitRatio * 100.0;
    }

    @Override
    public long getHedgedReadOps() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadOps();
    }

    @Override
    public long getHedgedReadWins() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadWins();
    }

    @Override
    public long getBlockedRequestsCount() {
        return this.blockedRequestsCount;
    }

    @Override
    public long getAverageRegionSize() {
        return this.averageRegionSize;
    }

    @Override
    public long getDataMissCount() {
        return this.cacheStats.map(CacheStats::getDataMissCount).orElse(0L);
    }

    @Override
    public long getLeafIndexMissCount() {
        return this.cacheStats.map(CacheStats::getLeafIndexMissCount).orElse(0L);
    }

    @Override
    public long getBloomChunkMissCount() {
        return this.cacheStats.map(CacheStats::getBloomChunkMissCount).orElse(0L);
    }

    @Override
    public long getMetaMissCount() {
        return this.cacheStats.map(CacheStats::getMetaMissCount).orElse(0L);
    }

    @Override
    public long getRootIndexMissCount() {
        return this.cacheStats.map(CacheStats::getRootIndexMissCount).orElse(0L);
    }

    @Override
    public long getIntermediateIndexMissCount() {
        return this.cacheStats.map(CacheStats::getIntermediateIndexMissCount).orElse(0L);
    }

    @Override
    public long getFileInfoMissCount() {
        return this.cacheStats.map(CacheStats::getFileInfoMissCount).orElse(0L);
    }

    @Override
    public long getGeneralBloomMetaMissCount() {
        return this.cacheStats.map(CacheStats::getGeneralBloomMetaMissCount).orElse(0L);
    }

    @Override
    public long getDeleteFamilyBloomMissCount() {
        return this.cacheStats.map(CacheStats::getDeleteFamilyBloomMissCount).orElse(0L);
    }

    @Override
    public long getTrailerMissCount() {
        return this.cacheStats.map(CacheStats::getTrailerMissCount).orElse(0L);
    }

    @Override
    public long getDataHitCount() {
        return this.cacheStats.map(CacheStats::getDataHitCount).orElse(0L);
    }

    @Override
    public long getLeafIndexHitCount() {
        return this.cacheStats.map(CacheStats::getLeafIndexHitCount).orElse(0L);
    }

    @Override
    public long getBloomChunkHitCount() {
        return this.cacheStats.map(CacheStats::getBloomChunkHitCount).orElse(0L);
    }

    @Override
    public long getMetaHitCount() {
        return this.cacheStats.map(CacheStats::getMetaHitCount).orElse(0L);
    }

    @Override
    public long getRootIndexHitCount() {
        return this.cacheStats.map(CacheStats::getRootIndexHitCount).orElse(0L);
    }

    @Override
    public long getIntermediateIndexHitCount() {
        return this.cacheStats.map(CacheStats::getIntermediateIndexHitCount).orElse(0L);
    }

    @Override
    public long getFileInfoHitCount() {
        return this.cacheStats.map(CacheStats::getFileInfoHitCount).orElse(0L);
    }

    @Override
    public long getGeneralBloomMetaHitCount() {
        return this.cacheStats.map(CacheStats::getGeneralBloomMetaHitCount).orElse(0L);
    }

    @Override
    public long getDeleteFamilyBloomHitCount() {
        return this.cacheStats.map(CacheStats::getDeleteFamilyBloomHitCount).orElse(0L);
    }

    @Override
    public long getTrailerHitCount() {
        return this.cacheStats.map(CacheStats::getTrailerHitCount).orElse(0L);
    }

    public class RegionServerMetricsWrapperRunnable
    implements Runnable {
        private long lastRan = 0L;
        private long lastRequestCount = 0L;
        private long lastReadRequestsCount = 0L;
        private long lastWriteRequestsCount = 0L;

        @Override
        public synchronized void run() {
            try {
                HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
                HDFSBlocksDistribution hdfsBlocksDistributionSecondaryRegions = new HDFSBlocksDistribution();
                long tempNumStores = 0L;
                long tempNumStoreFiles = 0L;
                long tempMemstoreSize = 0L;
                long tempStoreFileSize = 0L;
                long tempMaxStoreFileAge = 0L;
                long tempNumReferenceFiles = 0L;
                long avgAgeNumerator = 0L;
                long numHFiles = 0L;
                long tempMinStoreFileAge = Long.MAX_VALUE;
                long tempReadRequestsCount = 0L;
                long tempFilteredReadRequestsCount = 0L;
                long tempWriteRequestsCount = 0L;
                long tempCheckAndMutateChecksFailed = 0L;
                long tempCheckAndMutateChecksPassed = 0L;
                long tempStorefileIndexSize = 0L;
                long tempTotalStaticIndexSize = 0L;
                long tempTotalStaticBloomSize = 0L;
                long tempNumMutationsWithoutWAL = 0L;
                long tempDataInMemoryWithoutWAL = 0L;
                double tempPercentFileLocal = 0.0;
                double tempPercentFileLocalSecondaryRegions = 0.0;
                long tempFlushedCellsCount = 0L;
                long tempCompactedCellsCount = 0L;
                long tempMajorCompactedCellsCount = 0L;
                long tempFlushedCellsSize = 0L;
                long tempCompactedCellsSize = 0L;
                long tempMajorCompactedCellsSize = 0L;
                long tempCellsCountCompactedToMob = 0L;
                long tempCellsCountCompactedFromMob = 0L;
                long tempCellsSizeCompactedToMob = 0L;
                long tempCellsSizeCompactedFromMob = 0L;
                long tempMobFlushCount = 0L;
                long tempMobFlushedCellsCount = 0L;
                long tempMobFlushedCellsSize = 0L;
                long tempMobScanCellsCount = 0L;
                long tempMobScanCellsSize = 0L;
                long tempBlockedRequestsCount = 0L;
                int regionCount = 0;
                for (HRegion r : MetricsRegionServerWrapperImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                    tempNumMutationsWithoutWAL += r.getNumMutationsWithoutWAL();
                    tempDataInMemoryWithoutWAL += r.getDataInMemoryWithoutWAL();
                    tempReadRequestsCount += r.getReadRequestsCount();
                    tempFilteredReadRequestsCount += r.getFilteredReadRequestsCount();
                    tempWriteRequestsCount += r.getWriteRequestsCount();
                    tempCheckAndMutateChecksFailed += r.getCheckAndMutateChecksFailed();
                    tempCheckAndMutateChecksPassed += r.getCheckAndMutateChecksPassed();
                    tempBlockedRequestsCount += r.getBlockedRequestsCount();
                    List<HStore> storeList = r.getStores();
                    tempNumStores += (long)storeList.size();
                    for (Store store : storeList) {
                        OptionalLong storeMinStoreFileAge;
                        tempNumStoreFiles += (long)store.getStorefilesCount();
                        tempMemstoreSize += store.getMemStoreSize().getDataSize();
                        tempStoreFileSize += store.getStorefilesSize();
                        OptionalLong storeMaxStoreFileAge = store.getMaxStoreFileAge();
                        if (storeMaxStoreFileAge.isPresent() && storeMaxStoreFileAge.getAsLong() > tempMaxStoreFileAge) {
                            tempMaxStoreFileAge = storeMaxStoreFileAge.getAsLong();
                        }
                        if ((storeMinStoreFileAge = store.getMinStoreFileAge()).isPresent() && storeMinStoreFileAge.getAsLong() < tempMinStoreFileAge) {
                            tempMinStoreFileAge = storeMinStoreFileAge.getAsLong();
                        }
                        long storeHFiles = store.getNumHFiles();
                        numHFiles += storeHFiles;
                        tempNumReferenceFiles += store.getNumReferenceFiles();
                        OptionalDouble storeAvgStoreFileAge = store.getAvgStoreFileAge();
                        if (storeAvgStoreFileAge.isPresent()) {
                            avgAgeNumerator = (long)((double)avgAgeNumerator + storeAvgStoreFileAge.getAsDouble() * (double)storeHFiles);
                        }
                        tempStorefileIndexSize += store.getStorefilesRootLevelIndexSize();
                        tempTotalStaticBloomSize += store.getTotalStaticBloomSize();
                        tempTotalStaticIndexSize += store.getTotalStaticIndexSize();
                        tempFlushedCellsCount += store.getFlushedCellsCount();
                        tempCompactedCellsCount += store.getCompactedCellsCount();
                        tempMajorCompactedCellsCount += store.getMajorCompactedCellsCount();
                        tempFlushedCellsSize += store.getFlushedCellsSize();
                        tempCompactedCellsSize += store.getCompactedCellsSize();
                        tempMajorCompactedCellsSize += store.getMajorCompactedCellsSize();
                        if (!(store instanceof HMobStore)) continue;
                        HMobStore mobStore = (HMobStore)store;
                        tempCellsCountCompactedToMob += mobStore.getCellsCountCompactedToMob();
                        tempCellsCountCompactedFromMob += mobStore.getCellsCountCompactedFromMob();
                        tempCellsSizeCompactedToMob += mobStore.getCellsSizeCompactedToMob();
                        tempCellsSizeCompactedFromMob += mobStore.getCellsSizeCompactedFromMob();
                        tempMobFlushCount += mobStore.getMobFlushCount();
                        tempMobFlushedCellsCount += mobStore.getMobFlushedCellsCount();
                        tempMobFlushedCellsSize += mobStore.getMobFlushedCellsSize();
                        tempMobScanCellsCount += mobStore.getMobScanCellsCount();
                        tempMobScanCellsSize += mobStore.getMobScanCellsSize();
                    }
                    HDFSBlocksDistribution distro = r.getHDFSBlocksDistribution();
                    hdfsBlocksDistribution.add(distro);
                    if (r.getRegionInfo().getReplicaId() != 0) {
                        hdfsBlocksDistributionSecondaryRegions.add(distro);
                    }
                    ++regionCount;
                }
                float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocal = Double.isNaN(tempBlockedRequestsCount) ? 0.0 : (double)(localityIndex * 100.0f);
                float localityIndexSecondaryRegions = hdfsBlocksDistributionSecondaryRegions.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocalSecondaryRegions = Double.isNaN(localityIndexSecondaryRegions) ? 0.0 : (double)(localityIndexSecondaryRegions * 100.0f);
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (this.lastRan == 0L) {
                    this.lastRan = currentTime - MetricsRegionServerWrapperImpl.this.period;
                }
                if (currentTime - this.lastRan > 0L) {
                    long l = MetricsRegionServerWrapperImpl.this.getTotalRequestCount();
                    MetricsRegionServerWrapperImpl.this.requestsPerSecond = (double)(l - this.lastRequestCount) / ((double)(currentTime - this.lastRan) / 1000.0);
                    this.lastRequestCount = l;
                    long intervalReadRequestsCount = tempReadRequestsCount - this.lastReadRequestsCount;
                    long intervalWriteRequestsCount = tempWriteRequestsCount - this.lastWriteRequestsCount;
                    double readRequestsRatePerMilliSecond = (double)intervalReadRequestsCount / (double)MetricsRegionServerWrapperImpl.this.period;
                    double writeRequestsRatePerMilliSecond = (double)intervalWriteRequestsCount / (double)MetricsRegionServerWrapperImpl.this.period;
                    MetricsRegionServerWrapperImpl.this.readRequestsRatePerSecond = readRequestsRatePerMilliSecond * 1000.0;
                    MetricsRegionServerWrapperImpl.this.writeRequestsRatePerSecond = writeRequestsRatePerMilliSecond * 1000.0;
                    this.lastReadRequestsCount = tempReadRequestsCount;
                    this.lastWriteRequestsCount = tempWriteRequestsCount;
                }
                this.lastRan = currentTime;
                WALProvider wALProvider = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.walFactory.getWALProvider();
                WALProvider metaProvider = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.walFactory.getMetaWALProvider();
                MetricsRegionServerWrapperImpl.this.numWALFiles = (wALProvider == null ? 0L : wALProvider.getNumLogFiles()) + (metaProvider == null ? 0L : metaProvider.getNumLogFiles());
                MetricsRegionServerWrapperImpl.this.walFileSize = (wALProvider == null ? 0L : wALProvider.getLogFileSize()) + (wALProvider == null ? 0L : wALProvider.getLogFileSize());
                MetricsRegionServerWrapperImpl.this.numStores = tempNumStores;
                MetricsRegionServerWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
                MetricsRegionServerWrapperImpl.this.memstoreSize = tempMemstoreSize;
                MetricsRegionServerWrapperImpl.this.storeFileSize = tempStoreFileSize;
                MetricsRegionServerWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
                if (regionCount > 0) {
                    MetricsRegionServerWrapperImpl.this.averageRegionSize = (MetricsRegionServerWrapperImpl.this.memstoreSize + MetricsRegionServerWrapperImpl.this.storeFileSize) / (long)regionCount;
                }
                if (tempMinStoreFileAge != Long.MAX_VALUE) {
                    MetricsRegionServerWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
                }
                if (numHFiles != 0L) {
                    MetricsRegionServerWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
                }
                MetricsRegionServerWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
                MetricsRegionServerWrapperImpl.this.readRequestsCount = tempReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.filteredReadRequestsCount = tempFilteredReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.writeRequestsCount = tempWriteRequestsCount;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksFailed = tempCheckAndMutateChecksFailed;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksPassed = tempCheckAndMutateChecksPassed;
                MetricsRegionServerWrapperImpl.this.storefileIndexSize = tempStorefileIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticIndexSize = tempTotalStaticIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticBloomSize = tempTotalStaticBloomSize;
                MetricsRegionServerWrapperImpl.this.numMutationsWithoutWAL = tempNumMutationsWithoutWAL;
                MetricsRegionServerWrapperImpl.this.dataInMemoryWithoutWAL = tempDataInMemoryWithoutWAL;
                MetricsRegionServerWrapperImpl.this.percentFileLocal = tempPercentFileLocal;
                MetricsRegionServerWrapperImpl.this.percentFileLocalSecondaryRegions = tempPercentFileLocalSecondaryRegions;
                MetricsRegionServerWrapperImpl.this.flushedCellsCount = tempFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.compactedCellsCount = tempCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsCount = tempMajorCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.flushedCellsSize = tempFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.compactedCellsSize = tempCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsSize = tempMajorCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.cellsCountCompactedToMob = tempCellsCountCompactedToMob;
                MetricsRegionServerWrapperImpl.this.cellsCountCompactedFromMob = tempCellsCountCompactedFromMob;
                MetricsRegionServerWrapperImpl.this.cellsSizeCompactedToMob = tempCellsSizeCompactedToMob;
                MetricsRegionServerWrapperImpl.this.cellsSizeCompactedFromMob = tempCellsSizeCompactedFromMob;
                MetricsRegionServerWrapperImpl.this.mobFlushCount = tempMobFlushCount;
                MetricsRegionServerWrapperImpl.this.mobFlushedCellsCount = tempMobFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.mobFlushedCellsSize = tempMobFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.mobScanCellsCount = tempMobScanCellsCount;
                MetricsRegionServerWrapperImpl.this.mobScanCellsSize = tempMobScanCellsSize;
                MetricsRegionServerWrapperImpl.this.mobFileCacheAccessCount = MetricsRegionServerWrapperImpl.this.mobFileCache.map(MobFileCache::getAccessCount).orElse(0L);
                MetricsRegionServerWrapperImpl.this.mobFileCacheMissCount = MetricsRegionServerWrapperImpl.this.mobFileCache.map(MobFileCache::getMissCount).orElse(0L);
                MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = MetricsRegionServerWrapperImpl.this.mobFileCache.map(MobFileCache::getHitRatio).orElse(0.0);
                if (Double.isNaN(MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio)) {
                    MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = 0.0;
                }
                MetricsRegionServerWrapperImpl.this.mobFileCacheEvictedCount = MetricsRegionServerWrapperImpl.this.mobFileCache.map(MobFileCache::getEvictedFileCount).orElse(0L);
                MetricsRegionServerWrapperImpl.this.mobFileCacheCount = MetricsRegionServerWrapperImpl.this.mobFileCache.map(MobFileCache::getCacheSize).orElse(0).intValue();
                MetricsRegionServerWrapperImpl.this.blockedRequestsCount = tempBlockedRequestsCount;
            }
            catch (Throwable e) {
                LOG.warn("Caught exception! Will suppress and retry.", e);
            }
        }
    }
}

