/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionStateListener;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.SwitchRpcThrottleProcedure;
import org.apache.hadoop.hbase.namespace.NamespaceAuditor;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettingsImpl;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RpcThrottleStorage;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterQuotaManager
implements RegionStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(MasterQuotaManager.class);
    private static final Map<RegionInfo, Long> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private final MasterServices masterServices;
    private NamedLock<String> namespaceLocks;
    private NamedLock<TableName> tableLocks;
    private NamedLock<String> userLocks;
    private NamedLock<String> regionServerLocks;
    private boolean initialized = false;
    private NamespaceAuditor namespaceQuotaManager;
    private ConcurrentHashMap<RegionInfo, SizeSnapshotWithTimestamp> regionSizes;
    private RpcThrottleStorage rpcThrottleStorage;

    public MasterQuotaManager(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    public void start() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.masterServices.getConfiguration())) {
            LOG.info("Quota support disabled");
            return;
        }
        if (!MetaTableAccessor.tableExists(this.masterServices.getConnection(), QuotaUtil.QUOTA_TABLE_NAME)) {
            LOG.info("Quota table not found. Creating...");
            this.createQuotaTable();
        }
        LOG.info("Initializing quota support");
        this.namespaceLocks = new NamedLock();
        this.tableLocks = new NamedLock();
        this.userLocks = new NamedLock();
        this.regionServerLocks = new NamedLock();
        this.regionSizes = new ConcurrentHashMap();
        this.namespaceQuotaManager = new NamespaceAuditor(this.masterServices);
        this.namespaceQuotaManager.start();
        this.initialized = true;
        this.rpcThrottleStorage = new RpcThrottleStorage(this.masterServices.getZooKeeper(), this.masterServices.getConfiguration());
    }

    public void stop() {
    }

    public boolean isQuotaInitialized() {
        return this.initialized && this.namespaceQuotaManager.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterProtos.SetQuotaResponse setQuota(MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.checkQuotaSupport();
        if (req.hasUserName()) {
            this.userLocks.lock(req.getUserName());
            try {
                if (req.hasTableName()) {
                    this.setUserQuota(req.getUserName(), ProtobufUtil.toTableName(req.getTableName()), req);
                }
                if (req.hasNamespace()) {
                    this.setUserQuota(req.getUserName(), req.getNamespace(), req);
                }
                this.setUserQuota(req.getUserName(), req);
            }
            finally {
                this.userLocks.unlock(req.getUserName());
            }
        } else if (req.hasTableName()) {
            TableName table = ProtobufUtil.toTableName(req.getTableName());
            this.tableLocks.lock(table);
            try {
                this.setTableQuota(table, req);
            }
            finally {
                this.tableLocks.unlock(table);
            }
        } else if (req.hasNamespace()) {
            this.namespaceLocks.lock(req.getNamespace());
            try {
                this.setNamespaceQuota(req.getNamespace(), req);
            }
            finally {
                this.namespaceLocks.unlock(req.getNamespace());
            }
        } else if (req.hasRegionServer()) {
            this.regionServerLocks.lock(req.getRegionServer());
            try {
                this.setRegionServerQuota(req.getRegionServer(), req);
            }
            finally {
                this.regionServerLocks.unlock(req.getRegionServer());
            }
        } else {
            throw new DoNotRetryIOException(new UnsupportedOperationException("a user, a table, a namespace or region server must be specified"));
        }
        return MasterProtos.SetQuotaResponse.newBuilder().build();
    }

    public void setUserQuota(final String userName, final MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public GlobalQuotaSettingsImpl fetch() throws IOException {
                return new GlobalQuotaSettingsImpl(req.getUserName(), null, null, null, QuotaUtil.getUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName));
            }

            @Override
            public void update(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                QuotaUtil.addUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, quotaPojo.toQuotas());
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName);
            }

            @Override
            public void preApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, quotaPojo);
            }

            @Override
            public void postApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, quotaPojo);
            }
        });
    }

    public void setUserQuota(final String userName, final TableName table, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public GlobalQuotaSettingsImpl fetch() throws IOException {
                return new GlobalQuotaSettingsImpl(userName, table, null, null, QuotaUtil.getUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, table));
            }

            @Override
            public void update(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                QuotaUtil.addUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, table, quotaPojo.toQuotas());
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, table);
            }

            @Override
            public void preApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, table, (GlobalQuotaSettings)quotaPojo);
            }

            @Override
            public void postApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, table, (GlobalQuotaSettings)quotaPojo);
            }
        });
    }

    public void setUserQuota(final String userName, final String namespace, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public GlobalQuotaSettingsImpl fetch() throws IOException {
                return new GlobalQuotaSettingsImpl(userName, null, namespace, null, QuotaUtil.getUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, namespace));
            }

            @Override
            public void update(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                QuotaUtil.addUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, namespace, quotaPojo.toQuotas());
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota(MasterQuotaManager.this.masterServices.getConnection(), userName, namespace);
            }

            @Override
            public void preApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, namespace, (GlobalQuotaSettings)quotaPojo);
            }

            @Override
            public void postApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, namespace, (GlobalQuotaSettings)quotaPojo);
            }
        });
    }

    public void setTableQuota(final TableName table, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public GlobalQuotaSettingsImpl fetch() throws IOException {
                return new GlobalQuotaSettingsImpl(null, table, null, null, QuotaUtil.getTableQuota(MasterQuotaManager.this.masterServices.getConnection(), table));
            }

            @Override
            public void update(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                QuotaUtil.addTableQuota(MasterQuotaManager.this.masterServices.getConnection(), table, quotaPojo.toQuotas());
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteTableQuota(MasterQuotaManager.this.masterServices.getConnection(), table);
            }

            @Override
            public void preApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetTableQuota(table, quotaPojo);
            }

            @Override
            public void postApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetTableQuota(table, quotaPojo);
            }
        });
    }

    public void setNamespaceQuota(final String namespace, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public GlobalQuotaSettingsImpl fetch() throws IOException {
                return new GlobalQuotaSettingsImpl(null, null, namespace, null, QuotaUtil.getNamespaceQuota(MasterQuotaManager.this.masterServices.getConnection(), namespace));
            }

            @Override
            public void update(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                QuotaUtil.addNamespaceQuota(MasterQuotaManager.this.masterServices.getConnection(), namespace, quotaPojo.toQuotas());
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteNamespaceQuota(MasterQuotaManager.this.masterServices.getConnection(), namespace);
            }

            @Override
            public void preApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetNamespaceQuota(namespace, quotaPojo);
            }

            @Override
            public void postApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetNamespaceQuota(namespace, quotaPojo);
            }
        });
    }

    public void setRegionServerQuota(final String regionServer, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public GlobalQuotaSettingsImpl fetch() throws IOException {
                return new GlobalQuotaSettingsImpl(null, null, null, regionServer, QuotaUtil.getRegionServerQuota(MasterQuotaManager.this.masterServices.getConnection(), regionServer));
            }

            @Override
            public void update(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                QuotaUtil.addRegionServerQuota(MasterQuotaManager.this.masterServices.getConnection(), regionServer, quotaPojo.toQuotas());
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteRegionServerQuota(MasterQuotaManager.this.masterServices.getConnection(), regionServer);
            }

            @Override
            public void preApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetRegionServerQuota(regionServer, quotaPojo);
            }

            @Override
            public void postApply(GlobalQuotaSettingsImpl quotaPojo) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetRegionServerQuota(regionServer, quotaPojo);
            }
        });
    }

    public void setNamespaceQuota(NamespaceDescriptor desc) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.addNamespace(desc);
        }
    }

    public void removeNamespaceQuota(String namespace) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.deleteNamespace(namespace);
        }
    }

    public MasterProtos.SwitchRpcThrottleResponse switchRpcThrottle(MasterProtos.SwitchRpcThrottleRequest request) throws IOException {
        boolean rpcThrottle = request.getRpcThrottleEnabled();
        if (this.initialized) {
            this.masterServices.getMasterCoprocessorHost().preSwitchRpcThrottle(rpcThrottle);
            boolean oldRpcThrottle = this.rpcThrottleStorage.isRpcThrottleEnabled();
            if (rpcThrottle != oldRpcThrottle) {
                LOG.info("{} switch rpc throttle from {} to {}", new Object[]{this.masterServices.getClientIdAuditPrefix(), oldRpcThrottle, rpcThrottle});
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                SwitchRpcThrottleProcedure procedure = new SwitchRpcThrottleProcedure(this.rpcThrottleStorage, rpcThrottle, this.masterServices.getServerName(), latch);
                this.masterServices.getMasterProcedureExecutor().submitProcedure(procedure);
                latch.await();
            } else {
                LOG.warn("Skip switch rpc throttle to {} because it's the same with old value", (Object)rpcThrottle);
            }
            MasterProtos.SwitchRpcThrottleResponse response = MasterProtos.SwitchRpcThrottleResponse.newBuilder().setPreviousRpcThrottleEnabled(oldRpcThrottle).build();
            this.masterServices.getMasterCoprocessorHost().postSwitchRpcThrottle(oldRpcThrottle, rpcThrottle);
            return response;
        }
        LOG.warn("Skip switch rpc throttle to {} because rpc quota is disabled", (Object)rpcThrottle);
        return MasterProtos.SwitchRpcThrottleResponse.newBuilder().setPreviousRpcThrottleEnabled(false).build();
    }

    public MasterProtos.IsRpcThrottleEnabledResponse isRpcThrottleEnabled(MasterProtos.IsRpcThrottleEnabledRequest request) throws IOException {
        if (this.initialized) {
            this.masterServices.getMasterCoprocessorHost().preIsRpcThrottleEnabled();
            boolean enabled = this.rpcThrottleStorage.isRpcThrottleEnabled();
            MasterProtos.IsRpcThrottleEnabledResponse response = MasterProtos.IsRpcThrottleEnabledResponse.newBuilder().setRpcThrottleEnabled(enabled).build();
            this.masterServices.getMasterCoprocessorHost().postIsRpcThrottleEnabled(enabled);
            return response;
        }
        LOG.warn("Skip get rpc throttle because rpc quota is disabled");
        return MasterProtos.IsRpcThrottleEnabledResponse.newBuilder().setRpcThrottleEnabled(false).build();
    }

    public MasterProtos.SwitchExceedThrottleQuotaResponse switchExceedThrottleQuota(MasterProtos.SwitchExceedThrottleQuotaRequest request) throws IOException {
        boolean enabled = request.getExceedThrottleQuotaEnabled();
        if (this.initialized) {
            this.masterServices.getMasterCoprocessorHost().preSwitchExceedThrottleQuota(enabled);
            boolean previousEnabled = QuotaUtil.isExceedThrottleQuotaEnabled(this.masterServices.getConnection());
            if (previousEnabled == enabled) {
                LOG.warn("Skip switch exceed throttle quota to {} because it's the same with old value", (Object)enabled);
            } else {
                QuotaUtil.switchExceedThrottleQuota(this.masterServices.getConnection(), enabled);
                LOG.info("{} switch exceed throttle quota from {} to {}", new Object[]{this.masterServices.getClientIdAuditPrefix(), previousEnabled, enabled});
            }
            MasterProtos.SwitchExceedThrottleQuotaResponse response = MasterProtos.SwitchExceedThrottleQuotaResponse.newBuilder().setPreviousExceedThrottleQuotaEnabled(previousEnabled).build();
            this.masterServices.getMasterCoprocessorHost().postSwitchExceedThrottleQuota(previousEnabled, enabled);
            return response;
        }
        LOG.warn("Skip switch exceed throttle quota to {} because quota is disabled", (Object)enabled);
        return MasterProtos.SwitchExceedThrottleQuotaResponse.newBuilder().setPreviousExceedThrottleQuotaEnabled(false).build();
    }

    private void setQuota(MasterProtos.SetQuotaRequest req, SetQuotaOperations quotaOps) throws IOException, InterruptedException {
        if (req.hasRemoveAll() && req.getRemoveAll()) {
            quotaOps.preApply(null);
            quotaOps.delete();
            quotaOps.postApply(null);
            return;
        }
        GlobalQuotaSettingsImpl currentQuota = quotaOps.fetch();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Current quota for request(" + TextFormat.shortDebugString(req) + "): " + currentQuota);
        }
        quotaOps.preApply(currentQuota);
        QuotaSettings newQuota = QuotaSettings.buildFromProto(req);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Deserialized quota from request: " + newQuota);
        }
        GlobalQuotaSettingsImpl mergedQuota = currentQuota.merge(newQuota);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed merged quota from current quota and user request: " + mergedQuota);
        }
        if (mergedQuota == null) {
            quotaOps.delete();
        } else {
            quotaOps.update(mergedQuota);
        }
        quotaOps.postApply(mergedQuota);
    }

    public void checkNamespaceTableAndRegionQuota(TableName tName, int regions) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToCreateTable(tName, regions);
        }
    }

    public void checkAndUpdateNamespaceRegionQuota(TableName tName, int regions) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToUpdateRegion(tName, regions);
        }
    }

    public int getRegionCountOfTable(TableName tName) throws IOException {
        if (this.initialized) {
            return this.namespaceQuotaManager.getRegionCountOfTable(tName);
        }
        return -1;
    }

    @Override
    public void onRegionMerged(RegionInfo mergedRegion) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.updateQuotaForRegionMerge(mergedRegion);
        }
    }

    @Override
    public void onRegionSplit(RegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToSplitRegion(hri);
        }
    }

    public void removeTableFromNamespaceQuota(TableName tName) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.removeFromNamespaceUsage(tName);
        }
    }

    public NamespaceAuditor getNamespaceQuotaManager() {
        return this.namespaceQuotaManager;
    }

    private void checkQuotaSupport() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.masterServices.getConfiguration())) {
            throw new DoNotRetryIOException(new UnsupportedOperationException("quota support disabled"));
        }
        if (!this.initialized) {
            long maxWaitTime = this.masterServices.getConfiguration().getLong("hbase.master.wait.for.quota.manager.init", 30000L);
            long startTime = EnvironmentEdgeManager.currentTime();
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for Quota Manager to be initialized.");
                    break;
                }
            } while (!this.initialized && EnvironmentEdgeManager.currentTime() - startTime < maxWaitTime);
            if (!this.initialized) {
                throw new IOException("Quota manager is uninitialized, please retry later.");
            }
        }
    }

    private void createQuotaTable() throws IOException {
        this.masterServices.createSystemTable(QuotaUtil.QUOTA_TABLE_DESC);
    }

    @Override
    public void onRegionSplitReverted(RegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.removeRegionFromNamespaceUsage(hri);
        }
    }

    @VisibleForTesting
    void initializeRegionSizes() {
        assert (this.regionSizes == null);
        this.regionSizes = new ConcurrentHashMap();
    }

    public void addRegionSize(RegionInfo hri, long size, long time) {
        if (this.regionSizes == null) {
            return;
        }
        this.regionSizes.put(hri, new SizeSnapshotWithTimestamp(size, time));
    }

    public Map<RegionInfo, Long> snapshotRegionSizes() {
        if (this.regionSizes == null) {
            return EMPTY_MAP;
        }
        HashMap<RegionInfo, Long> copy = new HashMap<RegionInfo, Long>();
        for (Map.Entry<RegionInfo, SizeSnapshotWithTimestamp> entry : this.regionSizes.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().getSize());
        }
        return copy;
    }

    int pruneEntriesOlderThan(long timeToPruneBefore) {
        if (this.regionSizes == null) {
            return 0;
        }
        int numEntriesRemoved = 0;
        Iterator<Map.Entry<RegionInfo, SizeSnapshotWithTimestamp>> iterator = this.regionSizes.entrySet().iterator();
        while (iterator.hasNext()) {
            long currentEntryTime = iterator.next().getValue().getTime();
            if (currentEntryTime >= timeToPruneBefore) continue;
            iterator.remove();
            ++numEntriesRemoved;
        }
        return numEntriesRemoved;
    }

    private static class SizeSnapshotWithTimestamp {
        private final long size;
        private final long time;

        public SizeSnapshotWithTimestamp(long size, long time) {
            this.size = size;
            this.time = time;
        }

        public long getSize() {
            return this.size;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o instanceof SizeSnapshotWithTimestamp) {
                SizeSnapshotWithTimestamp other = (SizeSnapshotWithTimestamp)o;
                return this.size == other.size && this.time == other.time;
            }
            return false;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            return hcb.append(this.size).append(this.time).toHashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("SizeSnapshotWithTimestamp={size=").append(this.size).append("B, ");
            sb.append("time=").append(this.time).append("}");
            return sb.toString();
        }
    }

    private static class NamedLock<T> {
        private final HashSet<T> locks = new HashSet();

        private NamedLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(T name) throws InterruptedException {
            HashSet<T> hashSet = this.locks;
            synchronized (hashSet) {
                while (this.locks.contains(name)) {
                    this.locks.wait();
                }
                this.locks.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(T name) {
            HashSet<T> hashSet = this.locks;
            synchronized (hashSet) {
                this.locks.remove(name);
                this.locks.notifyAll();
            }
        }
    }

    private static interface SetQuotaOperations {
        public GlobalQuotaSettingsImpl fetch() throws IOException;

        public void delete() throws IOException;

        public void update(GlobalQuotaSettingsImpl var1) throws IOException;

        public void preApply(GlobalQuotaSettingsImpl var1) throws IOException;

        public void postApply(GlobalQuotaSettingsImpl var1) throws IOException;
    }
}

