/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ModifyRegionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyRegionUtils.class);

    private ModifyRegionUtils() {
    }

    public static RegionInfo[] createRegionInfos(TableDescriptor tableDescriptor, byte[][] splitKeys) {
        long regionId = System.currentTimeMillis();
        RegionInfo[] hRegionInfos = null;
        if (splitKeys == null || splitKeys.length == 0) {
            hRegionInfos = new RegionInfo[]{RegionInfoBuilder.newBuilder(tableDescriptor.getTableName()).setStartKey(null).setEndKey(null).setSplit(false).setRegionId(regionId).build()};
        } else {
            int numRegions = splitKeys.length + 1;
            hRegionInfos = new RegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                hRegionInfos[i] = RegionInfoBuilder.newBuilder(tableDescriptor.getTableName()).setStartKey(startKey).setEndKey(endKey).setSplit(false).setRegionId(regionId).build();
                startKey = endKey;
            }
        }
        return hRegionInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RegionInfo> createRegions(Configuration conf, Path rootDir, TableDescriptor tableDescriptor, RegionInfo[] newRegions, RegionFillTask task) throws IOException {
        if (newRegions == null) {
            return null;
        }
        int regionNumber = newRegions.length;
        ThreadPoolExecutor exec = ModifyRegionUtils.getRegionOpenAndInitThreadPool(conf, "RegionOpenAndInitThread-" + tableDescriptor.getTableName(), regionNumber);
        try {
            List<RegionInfo> list = ModifyRegionUtils.createRegions(exec, conf, rootDir, tableDescriptor, newRegions, task);
            return list;
        }
        finally {
            exec.shutdownNow();
        }
    }

    public static List<RegionInfo> createRegions(ThreadPoolExecutor exec, final Configuration conf, final Path rootDir, final TableDescriptor tableDescriptor, RegionInfo[] newRegions, final RegionFillTask task) throws IOException {
        if (newRegions == null) {
            return null;
        }
        int regionNumber = newRegions.length;
        ExecutorCompletionService<RegionInfo> completionService = new ExecutorCompletionService<RegionInfo>(exec);
        ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>();
        for (final RegionInfo newRegion : newRegions) {
            completionService.submit(new Callable<RegionInfo>(){

                @Override
                public RegionInfo call() throws IOException {
                    return ModifyRegionUtils.createRegion(conf, rootDir, tableDescriptor, newRegion, task);
                }
            });
        }
        try {
            for (int i = 0; i < regionNumber; ++i) {
                regionInfos.add((RegionInfo)completionService.take().get());
            }
        }
        catch (InterruptedException e) {
            LOG.error("Caught " + e + " during region creation");
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        return regionInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionInfo createRegion(Configuration conf, Path rootDir, TableDescriptor tableDescriptor, RegionInfo newRegion, RegionFillTask task) throws IOException {
        Configuration confForWAL = new Configuration(conf);
        confForWAL.set("hbase.rootdir", rootDir.toString());
        try (HRegion region = HRegion.createHRegion(newRegion, rootDir, conf, tableDescriptor, null, false);){
            if (task != null) {
                task.fillRegion(region);
            }
        }
        return region.getRegionInfo();
    }

    public static void editRegions(ThreadPoolExecutor exec, Collection<RegionInfo> regions, final RegionEditTask task) throws IOException {
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(exec);
        for (final RegionInfo hri : regions) {
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    task.editRegion(hri);
                    return null;
                }
            });
        }
        try {
            for (final RegionInfo hri : regions) {
                completionService.take().get();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            IOException ex = new IOException();
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    static ThreadPoolExecutor getRegionOpenAndInitThreadPool(Configuration conf, final String threadNamePrefix, int regionNumber) {
        int maxThreads = Math.min(regionNumber, conf.getInt("hbase.hregion.open.and.init.threads.max", 16));
        ThreadPoolExecutor regionOpenAndInitThreadPool = Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadNamePrefix + "-" + this.count++);
            }
        });
        return regionOpenAndInitThreadPool;
    }

    public static interface RegionEditTask {
        public void editRegion(RegionInfo var1) throws IOException;
    }

    public static interface RegionFillTask {
        public void fillRegion(HRegion var1) throws IOException;
    }
}

