/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ConnectionCache {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionCache.class);
    private final Map<String, ConnectionInfo> connections = new ConcurrentHashMap<String, ConnectionInfo>();
    private final KeyLocker<String> locker = new KeyLocker();
    private final String realUserName;
    private final UserGroupInformation realUser;
    private final UserProvider userProvider;
    private final Configuration conf;
    private final ChoreService choreService;
    private final ThreadLocal<String> effectiveUserNames = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return ConnectionCache.this.realUserName;
        }
    };

    public ConnectionCache(Configuration conf, UserProvider userProvider, int cleanInterval, final int maxIdleTime) throws IOException {
        Stoppable stoppable = new Stoppable(){
            private volatile boolean isStopped = false;

            @Override
            public void stop(String why) {
                this.isStopped = true;
            }

            @Override
            public boolean isStopped() {
                return this.isStopped;
            }
        };
        this.choreService = new ChoreService("ConnectionCache");
        ScheduledChore cleaner = new ScheduledChore("ConnectionCleaner", stoppable, cleanInterval){

            @Override
            protected void chore() {
                for (Map.Entry entry : ConnectionCache.this.connections.entrySet()) {
                    ConnectionInfo connInfo = (ConnectionInfo)entry.getValue();
                    if (!connInfo.timedOut(maxIdleTime)) continue;
                    if (connInfo.admin != null) {
                        try {
                            connInfo.admin.close();
                        }
                        catch (Throwable t) {
                            LOG.info("Got exception in closing idle admin", t);
                        }
                    }
                    try {
                        connInfo.connection.close();
                    }
                    catch (Throwable t) {
                        LOG.info("Got exception in closing idle connection", t);
                    }
                }
            }
        };
        this.choreService.scheduleChore(cleaner);
        this.realUser = userProvider.getCurrent().getUGI();
        this.realUserName = this.realUser.getShortUserName();
        this.userProvider = userProvider;
        this.conf = conf;
    }

    public void setEffectiveUser(String user) {
        this.effectiveUserNames.set(user);
    }

    public String getEffectiveUser() {
        return this.effectiveUserNames.get();
    }

    public void shutdown() {
        if (this.choreService != null) {
            this.choreService.shutdown();
        }
    }

    public Admin getAdmin() throws IOException {
        ConnectionInfo connInfo = this.getCurrentConnection();
        if (connInfo.admin == null) {
            ReentrantLock lock = this.locker.acquireLock(this.getEffectiveUser());
            try {
                if (connInfo.admin == null) {
                    connInfo.admin = connInfo.connection.getAdmin();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return connInfo.admin;
    }

    public Table getTable(String tableName) throws IOException {
        ConnectionInfo connInfo = this.getCurrentConnection();
        return connInfo.connection.getTable(TableName.valueOf(tableName));
    }

    public RegionLocator getRegionLocator(byte[] tableName) throws IOException {
        return this.getCurrentConnection().connection.getRegionLocator(TableName.valueOf(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionInfo getCurrentConnection() throws IOException {
        String userName = this.getEffectiveUser();
        ConnectionInfo connInfo = this.connections.get(userName);
        if (connInfo == null || !connInfo.updateAccessTime()) {
            ReentrantLock lock = this.locker.acquireLock(userName);
            try {
                connInfo = this.connections.get(userName);
                if (connInfo == null) {
                    UserGroupInformation ugi = this.realUser;
                    if (!userName.equals(this.realUserName)) {
                        ugi = UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)this.realUser);
                    }
                    User user = this.userProvider.create(ugi);
                    Connection conn = ConnectionFactory.createConnection(this.conf, user);
                    connInfo = new ConnectionInfo(conn, userName);
                    this.connections.put(userName, connInfo);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return connInfo;
    }

    public boolean updateConnectionAccessTime() {
        String userName = this.getEffectiveUser();
        ConnectionInfo connInfo = this.connections.get(userName);
        if (connInfo != null) {
            return connInfo.updateAccessTime();
        }
        return false;
    }

    class ConnectionInfo {
        final Connection connection;
        final String userName;
        volatile Admin admin;
        private long lastAccessTime = EnvironmentEdgeManager.currentTime();
        private boolean closed;

        ConnectionInfo(Connection conn, String user) {
            this.connection = conn;
            this.closed = false;
            this.userName = user;
        }

        synchronized boolean updateAccessTime() {
            if (this.closed) {
                return false;
            }
            if (this.connection.isAborted() || this.connection.isClosed()) {
                LOG.info("Unexpected: cached Connection is aborted/closed, removed from cache");
                ConnectionCache.this.connections.remove(this.userName);
                return false;
            }
            this.lastAccessTime = EnvironmentEdgeManager.currentTime();
            return true;
        }

        synchronized boolean timedOut(int maxIdleTime) {
            long timeoutTime = this.lastAccessTime + (long)maxIdleTime;
            if (EnvironmentEdgeManager.currentTime() > timeoutTime) {
                ConnectionCache.this.connections.remove(this.userName);
                this.closed = true;
                return true;
            }
            return false;
        }
    }
}

