/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ipc.BalancedQueueRpcExecutor;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FastPathBalancedQueueRpcExecutor
extends BalancedQueueRpcExecutor {
    private final Deque<FastPathHandler> fastPathHandlerStack = new ConcurrentLinkedDeque<FastPathHandler>();

    public FastPathBalancedQueueRpcExecutor(String name, int handlerCount, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, maxQueueLength, priority, conf, abortable);
    }

    public FastPathBalancedQueueRpcExecutor(String name, int handlerCount, String callQueueType, int maxQueueLength, PriorityFunction priority, Configuration conf, Abortable abortable) {
        super(name, handlerCount, callQueueType, maxQueueLength, priority, conf, abortable);
    }

    @Override
    protected RpcExecutor.Handler getHandler(String name, double handlerFailureThreshhold, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount) {
        return new FastPathHandler(name, handlerFailureThreshhold, q, activeHandlerCount, this.fastPathHandlerStack);
    }

    @Override
    public boolean dispatch(CallRunner callTask) throws InterruptedException {
        FastPathHandler handler = this.popReadyHandler();
        return handler != null ? handler.loadCallRunner(callTask) : super.dispatch(callTask);
    }

    private FastPathHandler popReadyHandler() {
        return this.fastPathHandlerStack.poll();
    }

    class FastPathHandler
    extends RpcExecutor.Handler {
        final Deque<FastPathHandler> fastPathHandlerStack;
        private Semaphore semaphore;
        private CallRunner loadedCallRunner;

        FastPathHandler(String name, double handlerFailureThreshhold, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount, Deque<FastPathHandler> fastPathHandlerStack) {
            super(name, handlerFailureThreshhold, q, activeHandlerCount);
            this.semaphore = new Semaphore(0);
            this.fastPathHandlerStack = fastPathHandlerStack;
        }

        @Override
        protected CallRunner getCallRunner() throws InterruptedException {
            CallRunner cr = (CallRunner)this.q.poll();
            if (cr == null) {
                if (this.fastPathHandlerStack != null) {
                    this.fastPathHandlerStack.push(this);
                    this.semaphore.acquire();
                    cr = this.loadedCallRunner;
                    this.loadedCallRunner = null;
                } else {
                    cr = super.getCallRunner();
                }
            }
            return cr;
        }

        boolean loadCallRunner(CallRunner cr) {
            this.loadedCallRunner = cr;
            this.semaphore.release();
            return true;
        }
    }
}

