/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TableOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, Put> {
    public static final String OUTPUT_TABLE = "hbase.mapred.outputtable";

    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        return new TableRecordWriter(job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        String tableName = job.get(OUTPUT_TABLE);
        if (tableName == null) {
            throw new IOException("Must specify table name");
        }
    }

    protected static class TableRecordWriter
    implements RecordWriter<ImmutableBytesWritable, Put> {
        private BufferedMutator m_mutator;
        private Connection conn;

        @Deprecated
        public TableRecordWriter(BufferedMutator mutator) throws IOException {
            this.m_mutator = mutator;
            this.conn = null;
        }

        public TableRecordWriter(JobConf job) throws IOException {
            TableName tableName = TableName.valueOf(job.get(TableOutputFormat.OUTPUT_TABLE));
            try {
                this.conn = ConnectionFactory.createConnection((Configuration)job);
                this.m_mutator = this.conn.getBufferedMutator(tableName);
            }
            finally {
                if (this.m_mutator == null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
        }

        public void close(Reporter reporter) throws IOException {
            try {
                if (this.m_mutator != null) {
                    this.m_mutator.close();
                }
            }
            finally {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
        }

        public void write(ImmutableBytesWritable key, Put value) throws IOException {
            this.m_mutator.mutate(new Put(value));
        }
    }
}

