/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.InclusiveCombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CacheConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)CacheConfig.class.getName());
    public static final CacheConfig DISABLED = new CacheConfig();
    public static final String CACHE_DATA_ON_READ_KEY = "hbase.block.data.cacheonread";
    public static final String CACHE_BLOCKS_ON_WRITE_KEY = "hbase.rs.cacheblocksonwrite";
    public static final String CACHE_INDEX_BLOCKS_ON_WRITE_KEY = "hfile.block.index.cacheonwrite";
    public static final String CACHE_BLOOM_BLOCKS_ON_WRITE_KEY = "hfile.block.bloom.cacheonwrite";
    public static final String CACHE_DATA_BLOCKS_COMPRESSED_KEY = "hbase.block.data.cachecompressed";
    public static final String EVICT_BLOCKS_ON_CLOSE_KEY = "hbase.rs.evictblocksonclose";
    public static final String BUCKET_CACHE_PERSISTENT_PATH_KEY = "hbase.bucketcache.persistent.path";
    public static final String BUCKET_CACHE_WRITER_THREADS_KEY = "hbase.bucketcache.writer.threads";
    public static final String BUCKET_CACHE_WRITER_QUEUE_KEY = "hbase.bucketcache.writer.queuelength";
    public static final String BUCKET_CACHE_BUCKETS_KEY = "hbase.bucketcache.bucket.sizes";
    public static final int DEFAULT_BUCKET_CACHE_WRITER_THREADS = 3;
    public static final int DEFAULT_BUCKET_CACHE_WRITER_QUEUE = 64;
    public static final String PREFETCH_BLOCKS_ON_OPEN_KEY = "hbase.rs.prefetchblocksonopen";
    public static final String BLOCKCACHE_BLOCKSIZE_KEY = "hbase.offheapcache.minblocksize";
    private static final String EXTERNAL_BLOCKCACHE_KEY = "hbase.blockcache.use.external";
    private static final boolean EXTERNAL_BLOCKCACHE_DEFAULT = false;
    private static final String EXTERNAL_BLOCKCACHE_CLASS_KEY = "hbase.blockcache.external.class";
    private static final String DROP_BEHIND_CACHE_COMPACTION_KEY = "hbase.hfile.drop.behind.compaction";
    private static final boolean DROP_BEHIND_CACHE_COMPACTION_DEFAULT = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_READ = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_CACHE_INDEXES_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final boolean DEFAULT_EVICT_ON_CLOSE = false;
    public static final boolean DEFAULT_CACHE_DATA_COMPRESSED = false;
    public static final boolean DEFAULT_PREFETCH_ON_OPEN = false;
    private final BlockCache blockCache;
    private boolean cacheDataOnRead;
    private final boolean inMemory;
    private boolean cacheDataOnWrite;
    private final boolean cacheIndexesOnWrite;
    private final boolean cacheBloomsOnWrite;
    private boolean evictOnClose;
    private final boolean cacheDataCompressed;
    private final boolean prefetchOnOpen;
    private final boolean dropBehindCompaction;
    @VisibleForTesting
    static BlockCache GLOBAL_BLOCK_CACHE_INSTANCE;
    private static LruBlockCache ONHEAP_CACHE_INSTANCE;
    private static BlockCache L2_CACHE_INSTANCE;
    @VisibleForTesting
    static boolean blockCacheDisabled;

    public CacheConfig(Configuration conf, ColumnFamilyDescriptor family) {
        this(GLOBAL_BLOCK_CACHE_INSTANCE, conf.getBoolean(CACHE_DATA_ON_READ_KEY, true) && family.isBlockCacheEnabled(), family.isInMemory(), conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false) || family.isCacheDataOnWrite(), conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false) || family.isCacheIndexesOnWrite(), conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false) || family.isCacheBloomsOnWrite(), conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false) || family.isEvictBlocksOnClose(), conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false), conf.getBoolean(PREFETCH_BLOCKS_ON_OPEN_KEY, false) || family.isPrefetchBlocksOnOpen(), conf.getBoolean(DROP_BEHIND_CACHE_COMPACTION_KEY, true));
        LOG.info("Created cacheConfig for " + family.getNameAsString() + ": " + this);
    }

    public CacheConfig(Configuration conf) {
        this(GLOBAL_BLOCK_CACHE_INSTANCE, conf.getBoolean(CACHE_DATA_ON_READ_KEY, true), false, conf.getBoolean(CACHE_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(CACHE_INDEX_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(CACHE_BLOOM_BLOCKS_ON_WRITE_KEY, false), conf.getBoolean(EVICT_BLOCKS_ON_CLOSE_KEY, false), conf.getBoolean(CACHE_DATA_BLOCKS_COMPRESSED_KEY, false), conf.getBoolean(PREFETCH_BLOCKS_ON_OPEN_KEY, false), conf.getBoolean(DROP_BEHIND_CACHE_COMPACTION_KEY, true));
        LOG.info("Created cacheConfig: " + this);
    }

    @VisibleForTesting
    CacheConfig(BlockCache blockCache, boolean cacheDataOnRead, boolean inMemory, boolean cacheDataOnWrite, boolean cacheIndexesOnWrite, boolean cacheBloomsOnWrite, boolean evictOnClose, boolean cacheDataCompressed, boolean prefetchOnOpen, boolean dropBehindCompaction) {
        this.blockCache = blockCache;
        this.cacheDataOnRead = cacheDataOnRead;
        this.inMemory = inMemory;
        this.cacheDataOnWrite = cacheDataOnWrite;
        this.cacheIndexesOnWrite = cacheIndexesOnWrite;
        this.cacheBloomsOnWrite = cacheBloomsOnWrite;
        this.evictOnClose = evictOnClose;
        this.cacheDataCompressed = cacheDataCompressed;
        this.prefetchOnOpen = prefetchOnOpen;
        this.dropBehindCompaction = dropBehindCompaction;
    }

    public CacheConfig(CacheConfig cacheConf) {
        this(cacheConf.blockCache, cacheConf.cacheDataOnRead, cacheConf.inMemory, cacheConf.cacheDataOnWrite, cacheConf.cacheIndexesOnWrite, cacheConf.cacheBloomsOnWrite, cacheConf.evictOnClose, cacheConf.cacheDataCompressed, cacheConf.prefetchOnOpen, cacheConf.dropBehindCompaction);
    }

    private CacheConfig() {
        this(null, false, false, false, false, false, false, false, false, false);
    }

    public boolean isBlockCacheEnabled() {
        return this.blockCache != null;
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    public boolean shouldCacheDataOnRead() {
        return this.isBlockCacheEnabled() && this.cacheDataOnRead;
    }

    public boolean shouldDropBehindCompaction() {
        return this.dropBehindCompaction;
    }

    public boolean shouldCacheBlockOnRead(BlockType.BlockCategory category) {
        return this.isBlockCacheEnabled() && (this.cacheDataOnRead || category == BlockType.BlockCategory.INDEX || category == BlockType.BlockCategory.BLOOM || this.prefetchOnOpen && category != BlockType.BlockCategory.META && category != BlockType.BlockCategory.UNKNOWN);
    }

    public boolean isInMemory() {
        return this.isBlockCacheEnabled() && this.inMemory;
    }

    public boolean shouldCacheDataOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheDataOnWrite;
    }

    @VisibleForTesting
    public void setCacheDataOnWrite(boolean cacheDataOnWrite) {
        this.cacheDataOnWrite = cacheDataOnWrite;
    }

    public boolean shouldCacheIndexesOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheIndexesOnWrite;
    }

    public boolean shouldCacheBloomsOnWrite() {
        return this.isBlockCacheEnabled() && this.cacheBloomsOnWrite;
    }

    public boolean shouldEvictOnClose() {
        return this.isBlockCacheEnabled() && this.evictOnClose;
    }

    public void setEvictOnClose(boolean evictOnClose) {
        this.evictOnClose = evictOnClose;
    }

    public boolean shouldCacheDataCompressed() {
        return this.isBlockCacheEnabled() && this.cacheDataOnRead && this.cacheDataCompressed;
    }

    public boolean shouldCacheCompressed(BlockType.BlockCategory category) {
        if (!this.isBlockCacheEnabled()) {
            return false;
        }
        switch (category) {
            case DATA: {
                return this.cacheDataOnRead && this.cacheDataCompressed;
            }
        }
        return false;
    }

    public boolean shouldPrefetchOnOpen() {
        return this.isBlockCacheEnabled() && this.prefetchOnOpen;
    }

    public boolean shouldReadBlockFromCache(BlockType blockType) {
        if (!this.isBlockCacheEnabled()) {
            return false;
        }
        if (this.cacheDataOnRead) {
            return true;
        }
        if (this.prefetchOnOpen) {
            return true;
        }
        if (this.cacheDataOnWrite) {
            return true;
        }
        if (blockType == null) {
            return true;
        }
        return blockType.getCategory() == BlockType.BlockCategory.BLOOM || blockType.getCategory() == BlockType.BlockCategory.INDEX;
    }

    public boolean shouldLockOnCacheMiss(BlockType blockType) {
        if (blockType == null) {
            return true;
        }
        return this.shouldCacheBlockOnRead(blockType.getCategory());
    }

    public String toString() {
        if (!this.isBlockCacheEnabled()) {
            return "CacheConfig:disabled";
        }
        return "blockCache=" + this.getBlockCache() + ", cacheDataOnRead=" + this.shouldCacheDataOnRead() + ", cacheDataOnWrite=" + this.shouldCacheDataOnWrite() + ", cacheIndexesOnWrite=" + this.shouldCacheIndexesOnWrite() + ", cacheBloomsOnWrite=" + this.shouldCacheBloomsOnWrite() + ", cacheEvictOnClose=" + this.shouldEvictOnClose() + ", cacheDataCompressed=" + this.shouldCacheDataCompressed() + ", prefetchOnOpen=" + this.shouldPrefetchOnOpen();
    }

    public static LruBlockCache getOnHeapCache(Configuration c) {
        return CacheConfig.getOnHeapCacheInternal(c);
    }

    public CacheStats getOnHeapCacheStats() {
        if (ONHEAP_CACHE_INSTANCE != null) {
            return ONHEAP_CACHE_INSTANCE.getStats();
        }
        return null;
    }

    public CacheStats getL2CacheStats() {
        if (L2_CACHE_INSTANCE != null) {
            return L2_CACHE_INSTANCE.getStats();
        }
        return null;
    }

    private static synchronized LruBlockCache getOnHeapCacheInternal(Configuration c) {
        if (ONHEAP_CACHE_INSTANCE != null) {
            return ONHEAP_CACHE_INSTANCE;
        }
        long cacheSize = MemorySizeUtil.getOnHeapCacheSize(c);
        if (cacheSize < 0L) {
            blockCacheDisabled = true;
        }
        if (blockCacheDisabled) {
            return null;
        }
        int blockSize = c.getInt(BLOCKCACHE_BLOCKSIZE_KEY, 65536);
        LOG.info("Allocating onheap LruBlockCache size=" + StringUtils.byteDesc((long)cacheSize) + ", blockSize=" + StringUtils.byteDesc((long)blockSize));
        ONHEAP_CACHE_INSTANCE = new LruBlockCache(cacheSize, blockSize, true, c);
        return ONHEAP_CACHE_INSTANCE;
    }

    private static BlockCache getExternalBlockcache(Configuration c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to use External l2 cache");
        }
        Class klass = null;
        try {
            klass = ExternalBlockCaches.valueOf((String)c.get((String)EXTERNAL_BLOCKCACHE_CLASS_KEY, (String)"memcache")).clazz;
        }
        catch (IllegalArgumentException exception) {
            try {
                klass = c.getClass(EXTERNAL_BLOCKCACHE_CLASS_KEY, Class.forName("org.apache.hadoop.hbase.io.hfile.MemcachedBlockCache"));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        try {
            LOG.info("Creating external block cache of type: " + klass);
            return (BlockCache)ReflectionUtils.newInstance(klass, c);
        }
        catch (Exception e) {
            LOG.warn("Error creating external block cache", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static BucketCache getBucketCache(Configuration c) {
        String bucketCacheIOEngineName = c.get("hbase.bucketcache.ioengine", null);
        if (bucketCacheIOEngineName == null || bucketCacheIOEngineName.length() <= 0) {
            return null;
        }
        int blockSize = c.getInt(BLOCKCACHE_BLOCKSIZE_KEY, 65536);
        long bucketCacheSize = MemorySizeUtil.getBucketCacheSize(c);
        if (bucketCacheSize <= 0L) {
            throw new IllegalStateException("bucketCacheSize <= 0; Check hbase.bucketcache.size setting and/or server java heap size");
        }
        if (c.get("hbase.bucketcache.percentage.in.combinedcache") != null) {
            LOG.warn("Configuration 'hbase.bucketcache.percentage.in.combinedcache' is no longer respected. See comments in http://hbase.apache.org/book.html#_changes_of_note");
        }
        int writerThreads = c.getInt(BUCKET_CACHE_WRITER_THREADS_KEY, 3);
        int writerQueueLen = c.getInt(BUCKET_CACHE_WRITER_QUEUE_KEY, 64);
        String persistentPath = c.get(BUCKET_CACHE_PERSISTENT_PATH_KEY);
        String[] configuredBucketSizes = c.getStrings(BUCKET_CACHE_BUCKETS_KEY);
        int[] bucketSizes = null;
        if (configuredBucketSizes != null) {
            bucketSizes = new int[configuredBucketSizes.length];
            for (int i = 0; i < configuredBucketSizes.length; ++i) {
                int bucketSize = Integer.parseInt(configuredBucketSizes[i].trim());
                if (bucketSize % 256 != 0) {
                    throw new IllegalArgumentException("Illegal value: " + bucketSize + " configured for '" + BUCKET_CACHE_BUCKETS_KEY + "'. All bucket sizes to be multiples of 256");
                }
                bucketSizes[i] = bucketSize;
            }
        }
        BucketCache bucketCache = null;
        try {
            int ioErrorsTolerationDuration = c.getInt("hbase.bucketcache.ioengine.errors.tolerated.duration", 60000);
            bucketCache = new BucketCache(bucketCacheIOEngineName, bucketCacheSize, blockSize, bucketSizes, writerThreads, writerQueueLen, persistentPath, ioErrorsTolerationDuration, c);
        }
        catch (IOException ioex) {
            LOG.error("Can't instantiate bucket cache", (Throwable)ioex);
            throw new RuntimeException(ioex);
        }
        return bucketCache;
    }

    public static synchronized BlockCache instantiateBlockCache(Configuration conf) {
        if (GLOBAL_BLOCK_CACHE_INSTANCE != null) {
            return GLOBAL_BLOCK_CACHE_INSTANCE;
        }
        if (blockCacheDisabled) {
            return null;
        }
        LruBlockCache onHeapCache = CacheConfig.getOnHeapCacheInternal(conf);
        if (blockCacheDisabled) {
            return null;
        }
        boolean useExternal = conf.getBoolean(EXTERNAL_BLOCKCACHE_KEY, false);
        if (useExternal) {
            L2_CACHE_INSTANCE = CacheConfig.getExternalBlockcache(conf);
            GLOBAL_BLOCK_CACHE_INSTANCE = L2_CACHE_INSTANCE == null ? onHeapCache : new InclusiveCombinedBlockCache(onHeapCache, L2_CACHE_INSTANCE);
        } else {
            L2_CACHE_INSTANCE = CacheConfig.getBucketCache(conf);
            if (!conf.getBoolean("hbase.bucketcache.combinedcache.enabled", true)) {
                LOG.warn("From HBase 2.0 onwards only combined mode of LRU cache and bucket cache is available");
            }
            GLOBAL_BLOCK_CACHE_INSTANCE = L2_CACHE_INSTANCE == null ? onHeapCache : new CombinedBlockCache(onHeapCache, L2_CACHE_INSTANCE);
        }
        return GLOBAL_BLOCK_CACHE_INSTANCE;
    }

    @VisibleForTesting
    static synchronized void clearGlobalInstances() {
        ONHEAP_CACHE_INSTANCE = null;
        L2_CACHE_INSTANCE = null;
        GLOBAL_BLOCK_CACHE_INSTANCE = null;
    }

    static {
        ONHEAP_CACHE_INSTANCE = null;
        L2_CACHE_INSTANCE = null;
        blockCacheDisabled = false;
    }

    private static enum ExternalBlockCaches {
        memcached("org.apache.hadoop.hbase.io.hfile.MemcachedBlockCache");

        Class<? extends BlockCache> clazz;

        private ExternalBlockCaches(String clazzName) {
            try {
                this.clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException cnef) {
                this.clazz = null;
            }
        }

        private ExternalBlockCaches(Class<? extends BlockCache> clazz) {
            this.clazz = clazz;
        }
    }
}

