/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class ReflectionUtils {
    private static long previousLogTime = 0L;
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public static <T> T instantiateWithCustomCtor(String className, Class<?>[] ctorArgTypes, Object[] ctorArgs) {
        try {
            Class<?> resultType = Class.forName(className);
            Constructor<?> ctor = resultType.getDeclaredConstructor(ctorArgTypes);
            return (T)ReflectionUtils.instantiate(className, ctor, ctorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to find " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Unable to find suitable constructor for class " + className, e);
        }
    }

    public static <T> T instantiate(String className, Constructor<T> ctor, Object ... ctorArgs) {
        try {
            ctor.setAccessible(true);
            return ctor.newInstance(ctorArgs);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified class " + className, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Unable to instantiate specified class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Constructor threw an exception for " + className, e);
        }
    }

    public static <T> T newInstance(Class<T> type, Object ... params) {
        return ReflectionUtils.instantiate(type.getName(), ReflectionUtils.findConstructor(type, params), params);
    }

    public static <T> Constructor<T> findConstructor(Class<T> type, Object ... paramTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> ctor : constructors = type.getDeclaredConstructors()) {
            Class<?>[] ctorParamTypes = ctor.getParameterTypes();
            if (ctorParamTypes.length != paramTypes.length) continue;
            boolean match = true;
            for (int i = 0; i < ctorParamTypes.length && match; ++i) {
                if (paramTypes[i] == null) {
                    match = !ctorParamTypes[i].isPrimitive();
                    continue;
                }
                Class<?> paramType = paramTypes[i].getClass();
                match = !ctorParamTypes[i].isPrimitive() ? ctorParamTypes[i].isAssignableFrom(paramType) : Integer.TYPE.equals(ctorParamTypes[i]) && Integer.class.equals(paramType) || Long.TYPE.equals(ctorParamTypes[i]) && Long.class.equals(paramType) || Double.TYPE.equals(ctorParamTypes[i]) && Double.class.equals(paramType) || Character.TYPE.equals(ctorParamTypes[i]) && Character.class.equals(paramType) || Short.TYPE.equals(ctorParamTypes[i]) && Short.class.equals(paramType) || Boolean.TYPE.equals(ctorParamTypes[i]) && Boolean.class.equals(paramType) || Byte.TYPE.equals(ctorParamTypes[i]) && Byte.class.equals(paramType);
            }
            if (!match) continue;
            return ctor;
        }
        throw new UnsupportedOperationException("Unable to find suitable constructor for class " + type.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logThreadInfo(Logger log, String title, long minInterval) {
        boolean dumpStack = false;
        if (!log.isInfoEnabled()) return;
        Class<ReflectionUtils> clazz = ReflectionUtils.class;
        synchronized (ReflectionUtils.class) {
            long now = EnvironmentEdgeManager.currentTime();
            if (now - previousLogTime >= minInterval * 1000L) {
                previousLogTime = now;
                dumpStack = true;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!dumpStack) return;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ReflectionUtils.printThreadInfo(new PrintStream((OutputStream)buffer, false, "UTF-8"), title);
                log.info(buffer.toString(Charset.defaultCharset().name()));
                return;
            }
            catch (UnsupportedEncodingException ignored) {
                log.warn("Could not write thread info about '" + title + "' due to a string encoding issue.");
            }
            return;
        }
    }

    static void printThreadInfo(PrintStream stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + ReflectionUtils.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + ReflectionUtils.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    @NonNull
    public static Object invokeMethod(Object obj, String methodName, Object ... params) {
        try {
            Method m = obj.getClass().getMethod(methodName, ReflectionUtils.getParameterTypes(params));
            m.setAccessible(true);
            return m.invoke(obj, params);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Cannot find specified method " + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Unable to access specified method " + methodName, e);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException("Illegal arguments supplied for method " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Method threw an exception for " + methodName, e);
        }
    }

    private static Class<?>[] getParameterTypes(Object[] params) {
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            parameterTypes[i] = params[i].getClass();
        }
        return parameterTypes;
    }

    public static Field getModifiersField() throws IllegalAccessException, NoSuchFieldException {
        Field modifiersField = null;
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            try {
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                boolean accessibleBeforeSet = getDeclaredFields0.isAccessible();
                getDeclaredFields0.setAccessible(true);
                Field[] fields = (Field[])getDeclaredFields0.invoke(Field.class, false);
                getDeclaredFields0.setAccessible(accessibleBeforeSet);
                for (Field field : fields) {
                    if (!"modifiers".equals(field.getName())) continue;
                    modifiersField = field;
                    break;
                }
                if (modifiersField == null) {
                    throw e;
                }
            }
            catch (NoSuchMethodException ex) {
                e.addSuppressed(ex);
                throw e;
            }
            catch (InvocationTargetException ex) {
                e.addSuppressed(ex);
                throw e;
            }
        }
        return modifiersField;
    }
}

