/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base;

import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.EnumType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.ExplicitField;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.KerberosString;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.Realm;

public class KrbError
extends KrbMessage {
    static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(KrbErrorField.PVNO, Asn1Integer.class), new ExplicitField(KrbErrorField.MSG_TYPE, Asn1Integer.class), new ExplicitField(KrbErrorField.CTIME, KerberosTime.class), new ExplicitField(KrbErrorField.CUSEC, Asn1Integer.class), new ExplicitField(KrbErrorField.STIME, KerberosTime.class), new ExplicitField(KrbErrorField.SUSEC, Asn1Integer.class), new ExplicitField(KrbErrorField.ERROR_CODE, Asn1Integer.class), new ExplicitField(KrbErrorField.CREALM, Realm.class), new ExplicitField(KrbErrorField.CNAME, PrincipalName.class), new ExplicitField(KrbErrorField.REALM, Realm.class), new ExplicitField(KrbErrorField.SNAME, PrincipalName.class), new ExplicitField(KrbErrorField.ETEXT, KerberosString.class), new ExplicitField(KrbErrorField.EDATA, Asn1OctetString.class)};

    public KrbError() {
        super(KrbMessageType.KRB_ERROR, fieldInfos);
    }

    public KerberosTime getCtime() {
        return this.getFieldAs(KrbErrorField.CTIME, KerberosTime.class);
    }

    public void setCtime(KerberosTime ctime) {
        this.setFieldAs(KrbErrorField.CTIME, ctime);
    }

    public int getCusec() {
        return this.getFieldAsInt(KrbErrorField.CUSEC);
    }

    public void setCusec(int cusec) {
        this.setFieldAsInt(KrbErrorField.CUSEC, cusec);
    }

    public KerberosTime getStime() {
        return this.getFieldAs(KrbErrorField.STIME, KerberosTime.class);
    }

    public void setStime(KerberosTime stime) {
        this.setFieldAs(KrbErrorField.STIME, stime);
    }

    public int getSusec() {
        return this.getFieldAsInt(KrbErrorField.SUSEC);
    }

    public void setSusec(int susec) {
        this.setFieldAsInt(KrbErrorField.SUSEC, susec);
    }

    public KrbErrorCode getErrorCode() {
        return KrbErrorCode.fromValue(this.getFieldAsInt(KrbErrorField.ERROR_CODE));
    }

    public void setErrorCode(KrbErrorCode errorCode) {
        this.setFieldAsInt(KrbErrorField.ERROR_CODE, errorCode.getValue());
    }

    public String getCrealm() {
        return this.getFieldAsString(KrbErrorField.CREALM);
    }

    public void setCrealm(String realm) {
        this.setFieldAs(KrbErrorField.CREALM, new Realm(realm));
    }

    public PrincipalName getCname() {
        return this.getFieldAs(KrbErrorField.CNAME, PrincipalName.class);
    }

    public void setCname(PrincipalName cname) {
        this.setFieldAs(KrbErrorField.CNAME, cname);
    }

    public PrincipalName getSname() {
        return this.getFieldAs(KrbErrorField.SNAME, PrincipalName.class);
    }

    public void setSname(PrincipalName sname) {
        this.setFieldAs(KrbErrorField.SNAME, sname);
    }

    public String getRealm() {
        return this.getFieldAsString(KrbErrorField.REALM);
    }

    public void setRealm(String realm) {
        this.setFieldAs(KrbErrorField.REALM, new Realm(realm));
    }

    public String getEtext() {
        return this.getFieldAsString(KrbErrorField.ETEXT);
    }

    public void setEtext(String text) {
        this.setFieldAs(KrbErrorField.ETEXT, new KerberosString(text));
    }

    public byte[] getEdata() {
        return this.getFieldAsOctetBytes(KrbErrorField.EDATA);
    }

    public void setEdata(byte[] edata) {
        this.setFieldAsOctetBytes(KrbErrorField.EDATA, edata);
    }

    protected static enum KrbErrorField implements EnumType
    {
        PVNO,
        MSG_TYPE,
        CTIME,
        CUSEC,
        STIME,
        SUSEC,
        ERROR_CODE,
        CREALM,
        CNAME,
        REALM,
        SNAME,
        ETEXT,
        EDATA;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

