/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.key;

import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.key.AbstractKeyMaker;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Des;

public class DesKeyMaker
extends AbstractKeyMaker {
    public DesKeyMaker(EncryptProvider encProvider) {
        super(encProvider);
    }

    @Override
    public byte[] str2key(String string, String salt, byte[] param) throws KrbException {
        String error = null;
        byte type = 0;
        if (param != null) {
            if (param.length != 1) {
                error = "Invalid param to S2K";
            }
            if ((type = param[0]) != 0 && type != 1) {
                error = "Invalid param to S2K";
            }
        }
        if (type == 1) {
            error = "AFS not supported yet";
        }
        if (error != null) {
            throw new KrbException(error);
        }
        return this.toKey(string, salt);
    }

    private byte[] toKey(String string, String salt) throws KrbException {
        byte[] bytes = DesKeyMaker.makePasswdSalt(string, salt);
        byte[] paddedBytes = BytesUtil.padding(bytes, 8);
        byte[] fanFoldedKey = DesKeyMaker.fanFold(string, salt, paddedBytes);
        byte[] intermediateKey = DesKeyMaker.intermediateKey(fanFoldedKey);
        byte[] key = this.desEncryptedKey(intermediateKey, paddedBytes);
        DesKeyMaker.keyCorrection(key);
        return key;
    }

    public static byte[] fanFold(String string, String salt, byte[] paddedBytes) {
        if (paddedBytes == null) {
            byte[] bytes = DesKeyMaker.makePasswdSalt(string, salt);
            paddedBytes = BytesUtil.padding(bytes, 8);
        }
        int blocksOfbytes8 = paddedBytes.length / 8;
        boolean odd = true;
        byte[] bits56 = new byte[8];
        byte[] tempString = new byte[8];
        for (int i = 0; i < blocksOfbytes8; ++i) {
            System.arraycopy(paddedBytes, 8 * i, bits56, 0, 8);
            DesKeyMaker.removeMSBits(bits56);
            if (!odd) {
                DesKeyMaker.reverse(bits56);
            }
            odd = !odd;
            BytesUtil.xor(bits56, 0, tempString);
        }
        return tempString;
    }

    public static byte[] intermediateKey(byte[] fanFoldedKey) {
        byte[] keyBytes = DesKeyMaker.addParityBits(fanFoldedKey);
        DesKeyMaker.keyCorrection(keyBytes);
        return keyBytes;
    }

    private byte[] desEncryptedKey(byte[] intermediateKey, byte[] originalBytes) throws KrbException {
        byte[] resultKey = null;
        if (!this.encProvider().supportCbcMac()) {
            throw new KrbException("cbcMac should be supported by the provider: " + this.encProvider().getClass());
        }
        resultKey = this.encProvider().cbcMac(intermediateKey, intermediateKey, originalBytes);
        DesKeyMaker.keyCorrection(resultKey);
        return resultKey;
    }

    private static byte[] getEightBits(byte[] bits56) {
        byte[] bits64 = new byte[8];
        System.arraycopy(bits56, 0, bits64, 0, 7);
        bits64[7] = (byte)((bits56[0] & 1) << 1 | (bits56[1] & 1) << 2 | (bits56[2] & 1) << 3 | (bits56[3] & 1) << 4 | (bits56[4] & 1) << 5 | (bits56[5] & 1) << 6 | (bits56[6] & 1) << 7);
        return bits64;
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        if (randomBits.length != this.encProvider().keyInputSize()) {
            throw new KrbException("Invalid random bits, not of correct bytes size");
        }
        byte[] keyBytes = DesKeyMaker.getEightBits(randomBits);
        DesKeyMaker.addParity(keyBytes);
        DesKeyMaker.keyCorrection(keyBytes);
        return keyBytes;
    }

    private static byte[] removeMSBits(byte[] bits56) {
        return bits56;
    }

    private static void reverse(byte[] bits56) {
        byte bt;
        for (int i = 0; i < 8; ++i) {
            bt = bits56[i];
            int t1 = bt >> 6 & 1;
            int t2 = bt >> 0 & 1;
            if (t1 != t2) {
                bt = (byte)(bt ^ 0x41);
            }
            if ((t1 = bt >> 5 & 1) != (t2 = bt >> 1 & 1)) {
                bt = (byte)(bt ^ 0x22);
            }
            if ((t1 = bt >> 4 & 1) != (t2 = bt >> 2 & 1)) {
                bt = (byte)(bt ^ 0x14);
            }
            bits56[i] = bt;
        }
        bt = bits56[7];
        bits56[7] = bits56[0];
        bits56[0] = bt;
        bt = bits56[6];
        bits56[6] = bits56[1];
        bits56[1] = bt;
        bt = bits56[5];
        bits56[5] = bits56[2];
        bits56[2] = bt;
        bt = bits56[4];
        bits56[4] = bits56[3];
        bits56[3] = bt;
    }

    private static byte[] addParityBits(byte[] bits56) {
        int i = 0;
        while (i < 8) {
            int n = i++;
            bits56[n] = (byte)(bits56[n] << 1);
        }
        DesKeyMaker.addParity(bits56);
        return bits56;
    }

    private static void keyCorrection(byte[] key) {
        DesKeyMaker.addParity(key);
        Des.fixKey(key, 0, key.length);
    }

    private static int smask(int step) {
        return (1 << step) - 1;
    }

    private static byte pstep(byte x, int step) {
        return (byte)(x & DesKeyMaker.smask(step) ^ x >> step & DesKeyMaker.smask(step));
    }

    private static byte parityChar(byte abyte) {
        return DesKeyMaker.pstep(DesKeyMaker.pstep(DesKeyMaker.pstep(abyte, 4), 2), 1);
    }

    private static void addParity(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            int n = i;
            key[n] = (byte)(key[n] & 0xFE);
            int n2 = i;
            key[n2] = (byte)(key[n2] | 1 ^ DesKeyMaker.parityChar(key[i]));
        }
    }

    private static boolean checkKeyParity(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            if ((key[i] & 1) != DesKeyMaker.parityChar((byte)(key[i] & 0xFE))) continue;
            return false;
        }
        return true;
    }
}

