/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command;

import java.io.Console;
import java.util.Scanner;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminClient;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteCommand;

public class RemoteRenamePrincipalCommand
extends RemoteCommand {
    public static final String USAGE = "Usage: rename_principal <old_principal_name> <new_principal_name>\n\tExample:\n\t\trename_principal alice bob\n";

    public RemoteRenamePrincipalCommand(AdminClient adminClient) {
        super(adminClient);
    }

    @Override
    public void execute(String input) throws KrbException {
        String reply;
        String[] items = input.split("\\s+");
        if (items.length < 3) {
            System.err.println(USAGE);
            return;
        }
        String adminRealm = this.adminClient.getAdminConfig().getAdminRealm();
        String oldPrincipalName = items[items.length - 2] + "@" + adminRealm;
        String newPrincipalName = items[items.length - 1] + "@" + adminRealm;
        Console console = System.console();
        String prompt = "Are you sure to rename the principal? (yes/no, YES/NO, y/n, Y/N) ";
        if (console == null) {
            System.out.println("Couldn't get Console instance, maybe you're running this from within an IDE. Use scanner to read password.");
            Scanner scanner = new Scanner(System.in, "UTF-8");
            reply = this.getReply(scanner, prompt);
        } else {
            reply = this.getReply(console, prompt);
        }
        if (reply.equals("yes") || reply.equals("YES") || reply.equals("y") || reply.equals("Y")) {
            this.adminClient.requestRenamePrincipal(oldPrincipalName, newPrincipalName);
        } else if (reply.equals("no") || reply.equals("NO") || reply.equals("n") || reply.equals("N")) {
            System.out.println("Principal \"" + oldPrincipalName + "\"  not renamed.");
        } else {
            System.err.println("Unknown request, fail to rename the principal.");
            System.err.println(USAGE);
        }
    }

    private String getReply(Scanner scanner, String prompt) {
        System.out.println(prompt);
        return scanner.nextLine().trim();
    }

    private String getReply(Console console, String prompt) {
        console.printf(prompt, new Object[0]);
        String line = console.readLine();
        return line;
    }
}

