/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Simple;

public abstract class Asn1String
extends Asn1Simple<String> {
    public Asn1String(UniversalTag universalTag) {
        super(universalTag, null);
    }

    public Asn1String(UniversalTag tagNo, String value) {
        super(tagNo, value);
    }

    @Override
    protected void toBytes() {
        if (this.getValue() != null) {
            byte[] bytes = ((String)this.getValue()).getBytes(StandardCharsets.US_ASCII);
            this.setBytes(bytes);
        }
    }

    @Override
    protected int encodingBodyLength() {
        if (this.getValue() != null) {
            return ((String)this.getValue()).length();
        }
        return 0;
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes = this.getBytes();
        this.setValue(new String(bytes, StandardCharsets.US_ASCII));
    }

    public static String fromUTF8ByteArray(byte[] bytes) {
        int i = 0;
        int length = 0;
        while (i < bytes.length) {
            ++length;
            if ((bytes[i] & 0xF0) == 240) {
                ++length;
                i += 4;
                continue;
            }
            if ((bytes[i] & 0xE0) == 224) {
                i += 3;
                continue;
            }
            if ((bytes[i] & 0xC0) == 192) {
                i += 2;
                continue;
            }
            ++i;
        }
        char[] cs = new char[length];
        i = 0;
        length = 0;
        while (i < bytes.length) {
            char ch;
            if ((bytes[i] & 0xF0) == 240) {
                int codePoint = (bytes[i] & 3) << 18 | (bytes[i + 1] & 0x3F) << 12 | (bytes[i + 2] & 0x3F) << 6 | bytes[i + 3] & 0x3F;
                int u = codePoint - 65536;
                char w1 = (char)(0xD800 | u >> 10);
                char w2 = (char)(0xDC00 | u & 0x3FF);
                cs[length++] = w1;
                ch = w2;
                i += 4;
            } else if ((bytes[i] & 0xE0) == 224) {
                ch = (char)((bytes[i] & 0xF) << 12 | (bytes[i + 1] & 0x3F) << 6 | bytes[i + 2] & 0x3F);
                i += 3;
            } else if ((bytes[i] & 0xD0) == 208) {
                ch = (char)((bytes[i] & 0x1F) << 6 | bytes[i + 1] & 0x3F);
                i += 2;
            } else if ((bytes[i] & 0xC0) == 192) {
                ch = (char)((bytes[i] & 0x1F) << 6 | bytes[i + 1] & 0x3F);
                i += 2;
            } else {
                ch = (char)(bytes[i] & 0xFF);
                ++i;
            }
            cs[length++] = ch;
        }
        return new String(cs);
    }

    public static byte[] toUTF8ByteArray(String string) {
        return Asn1String.toUTF8ByteArray(string.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] string) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Asn1String.toUTF8ByteArray(string, bOut);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return bOut.toByteArray();
    }

    public static void toUTF8ByteArray(char[] string, OutputStream sOut) throws IOException {
        char[] c = string;
        for (int i = 0; i < c.length; ++i) {
            char ch = c[i];
            if (ch < '\u0080') {
                sOut.write(ch);
                continue;
            }
            if (ch < '\u0800') {
                sOut.write(0xC0 | ch >> 6);
                sOut.write(0x80 | ch & 0x3F);
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                if (i + 1 >= c.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char w1 = ch;
                char w2 = ch = c[++i];
                if (w1 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int codePoint = (w1 & 0x3FF) << 10 | (w2 & 0x3FF) + 65536;
                sOut.write(0xF0 | codePoint >> 18);
                sOut.write(0x80 | codePoint >> 12 & 0x3F);
                sOut.write(0x80 | codePoint >> 6 & 0x3F);
                sOut.write(0x80 | codePoint & 0x3F);
                continue;
            }
            sOut.write(0xE0 | ch >> 12);
            sOut.write(0x80 | ch >> 6 & 0x3F);
            sOut.write(0x80 | ch & 0x3F);
        }
    }

    public static String toUpperCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        for (int i = 0; i != chars.length; ++i) {
            char ch = chars[i];
            if ('a' > ch || 'z' < ch) continue;
            changed = true;
            chars[i] = (char)(ch - 97 + 65);
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean changed = false;
        char[] chars = string.toCharArray();
        for (int i = 0; i != chars.length; ++i) {
            char ch = chars[i];
            if ('A' > ch || 'Z' < ch) continue;
            changed = true;
            chars[i] = (char)(ch - 65 + 97);
        }
        if (changed) {
            return new String(chars);
        }
        return string;
    }

    public static byte[] toByteArray(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i != bytes.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static byte[] toByteArray(String string) {
        byte[] bytes = new byte[string.length()];
        for (int i = 0; i != bytes.length; ++i) {
            char ch = string.charAt(i);
            bytes[i] = (byte)ch;
        }
        return bytes;
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(Asn1String.asCharArray(bytes));
    }

    public static char[] asCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i != chars.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    public static String[] split(String input, char delimiter) {
        ArrayList<String> v = new ArrayList<String>();
        boolean moreTokens = true;
        while (moreTokens) {
            int tokenLocation = input.indexOf(delimiter);
            if (tokenLocation > 0) {
                String subString = input.substring(0, tokenLocation);
                v.add(subString);
                input = input.substring(tokenLocation + 1);
                continue;
            }
            moreTokens = false;
            v.add(input);
        }
        return v.toArray(new String[v.size()]);
    }
}

