/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Converter;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Dumper;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Tag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Type;

public class Asn1Constructed
extends AbstractAsn1Type<List<Asn1Type>>
implements Asn1Dumpable {
    protected Asn1Container container;
    private boolean lazy = false;

    public Asn1Constructed(Tag tag) {
        super(tag);
        this.setValue(new ArrayList());
        this.usePrimitive(false);
    }

    public Asn1Container getContainer() {
        return this.container;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void addItem(Asn1Type value) {
        this.resetBodyLength();
        ((List)this.getValue()).add(value);
        if (value instanceof Asn1Encodeable) {
            ((Asn1Encodeable)value).outerEncodeable = this;
        }
    }

    public void clear() {
        this.resetBodyLength();
        ((List)this.getValue()).clear();
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        List valueItems = (List)this.getValue();
        int allLen = 0;
        for (Asn1Type item : valueItems) {
            if (item == null) continue;
            allLen += item.encodingLength();
        }
        return allLen;
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        List valueItems = (List)this.getValue();
        for (Asn1Type item : valueItems) {
            if (item == null) continue;
            item.encode(buffer);
        }
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        Asn1Container container;
        this.container = container = (Asn1Container)parseResult;
        this.useDefinitiveLength(parseResult.isDefinitiveLength());
        if (!this.isLazy()) {
            this.decodeElements();
        }
    }

    protected void decodeElements() throws IOException {
        for (Asn1ParseResult parsingItem : this.getContainer().getChildren()) {
            if (parsingItem.isEOC()) continue;
            Asn1Type tmpValue = Asn1Converter.convert(parsingItem, this.lazy);
            this.addItem(tmpValue);
        }
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        String typeStr = this.tag().typeStr() + " [" + "tag=" + this.tag() + ", len=" + this.getHeaderLength() + "+" + this.getBodyLength() + "] ";
        dumper.indent(indents).append(typeStr).newLine();
        List items = (List)this.getValue();
        int i = 0;
        for (Asn1Type aObj : items) {
            dumper.dumpType(indents + 4, aObj);
            if (i++ == items.size() - 1) continue;
            dumper.newLine();
        }
    }
}

