/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Tag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1Header;

public final class Asn1Reader {
    private ByteBuffer buffer;
    private int position;

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public Asn1Header readHeader() throws IOException {
        Tag tag = this.readTag();
        int valueLength = this.readLength();
        Asn1Header header = new Asn1Header(tag, valueLength);
        return header;
    }

    public Asn1Reader(ByteBuffer buffer) {
        this.buffer = buffer;
        this.position = buffer.position();
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean available() {
        return this.position < this.buffer.limit();
    }

    protected byte readByte() throws IOException {
        return this.buffer.get(this.position++);
    }

    private Tag readTag() throws IOException {
        int tagFlags = this.readTagFlags();
        int tagNo = this.readTagNo(tagFlags);
        return new Tag(tagFlags, tagNo);
    }

    private int readTagFlags() throws IOException {
        int tagFlags = this.readByte() & 0xFF;
        return tagFlags;
    }

    private int readTagNo(int tagFlags) throws IOException {
        int tagNo = tagFlags & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b = this.readByte() & 0xFF;
            if ((b & 0x7F) == 0) {
                throw new IOException("Invalid high tag number found");
            }
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = this.readByte();
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    private int readLength() throws IOException {
        int result = this.readByte() & 0xFF;
        if (result == 128) {
            return -1;
        }
        if (result > 127) {
            int length = result & 0x7F;
            if (length > 4) {
                throw new IOException("Bad length of more than 4 bytes: " + length);
            }
            result = 0;
            for (int i = 0; i < length; ++i) {
                int tmp = this.readByte() & 0xFF;
                result = (result << 8) + tmp;
            }
        }
        if (result < 0) {
            throw new IOException("Invalid length " + result);
        }
        return result;
    }
}

