/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.MapConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.io.FileHandler;

public class SystemConfiguration
extends MapConfiguration {
    private static Log log = LogFactory.getLog(SystemConfiguration.class);

    public SystemConfiguration() {
        super(System.getProperties());
    }

    public static void setSystemProperties(String fileName) throws ConfigurationException {
        SystemConfiguration.setSystemProperties(null, fileName);
    }

    public static void setSystemProperties(String basePath, String fileName) throws ConfigurationException {
        FileBasedConfiguration config = (FileBasedConfiguration)((Object)(fileName.endsWith(".xml") ? new XMLPropertiesConfiguration() : new PropertiesConfiguration()));
        FileHandler handler = new FileHandler(config);
        handler.setBasePath(basePath);
        handler.setFileName(fileName);
        handler.load();
        SystemConfiguration.setSystemProperties(config);
    }

    public static void setSystemProperties(Configuration systemConfig) {
        Iterator<String> iter = systemConfig.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = (String)systemConfig.getProperty(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting system property " + key + " to " + value));
            }
            System.setProperty(key, value);
        }
    }

    @Override
    protected Iterator<String> getKeysInternal() {
        return System.getProperties().stringPropertyNames().iterator();
    }
}

