/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.shaded.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class VisibilityClient {
    public static boolean isCellVisibilityEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_VISIBILITY);
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabel(Connection connection, String label) throws Throwable {
        return VisibilityClient.addLabels(connection, new String[]{label});
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse addLabels(Connection connection, final String[] labels) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.VisibilityLabelsRequest.Builder builder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
                    for (String label : labels) {
                        if (label.length() <= 0) continue;
                        VisibilityLabelsProtos.VisibilityLabel.Builder newBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
                        newBuilder.setLabel(UnsafeByteOperations.unsafeWrap(Bytes.toBytes(label)));
                        builder.addVisLabel(newBuilder.build());
                    }
                    service.addLabels(this.controller, builder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result.values().iterator().next();
            return visibilityLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse setAuths(Connection connection, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(connection, auths, user, true);
    }

    public static VisibilityLabelsProtos.GetAuthsResponse getAuths(Connection connection, final String user) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.GetAuthsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.GetAuthsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.GetAuthsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.GetAuthsRequest.Builder getAuthReqBuilder = VisibilityLabelsProtos.GetAuthsRequest.newBuilder();
                    getAuthReqBuilder.setUser(UnsafeByteOperations.unsafeWrap(Bytes.toBytes(user)));
                    service.getAuths(this.controller, getAuthReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.GetAuthsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.GetAuthsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = result.values().iterator().next();
            return getAuthsResponse;
        }
    }

    public static VisibilityLabelsProtos.ListLabelsResponse listLabels(Connection connection, final String regex) throws Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.ListLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.ListLabelsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.ListLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.ListLabelsRequest.Builder listAuthLabelsReqBuilder = VisibilityLabelsProtos.ListLabelsRequest.newBuilder();
                    if (regex != null) {
                        Pattern pattern = Pattern.compile(regex);
                        listAuthLabelsReqBuilder.setRegex(pattern.toString());
                    }
                    service.listLabels(this.controller, listAuthLabelsReqBuilder.build(), this.rpcCallback);
                    VisibilityLabelsProtos.ListLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.ListLabelsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.ListLabelsResponse listLabelsResponse = result.values().iterator().next();
            return listLabelsResponse;
        }
    }

    public static VisibilityLabelsProtos.VisibilityLabelsResponse clearAuths(Connection connection, String[] auths, String user) throws Throwable {
        return VisibilityClient.setOrClearAuths(connection, auths, user, false);
    }

    private static VisibilityLabelsProtos.VisibilityLabelsResponse setOrClearAuths(Connection connection, final String[] auths, final String user, final boolean setOrClear) throws IOException, ServiceException, Throwable {
        try (Table table = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);){
            Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse> callable = new Batch.Call<VisibilityLabelsProtos.VisibilityLabelsService, VisibilityLabelsProtos.VisibilityLabelsResponse>(){
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();

                @Override
                public VisibilityLabelsProtos.VisibilityLabelsResponse call(VisibilityLabelsProtos.VisibilityLabelsService service) throws IOException {
                    VisibilityLabelsProtos.SetAuthsRequest.Builder setAuthReqBuilder = VisibilityLabelsProtos.SetAuthsRequest.newBuilder();
                    setAuthReqBuilder.setUser(UnsafeByteOperations.unsafeWrap(Bytes.toBytes(user)));
                    for (String auth : auths) {
                        if (auth.length() <= 0) continue;
                        setAuthReqBuilder.addAuth(ByteString.copyFromUtf8(auth));
                    }
                    if (setOrClear) {
                        service.setAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    } else {
                        service.clearAuths(this.controller, setAuthReqBuilder.build(), this.rpcCallback);
                    }
                    VisibilityLabelsProtos.VisibilityLabelsResponse response = this.rpcCallback.get();
                    if (this.controller.failedOnException()) {
                        throw this.controller.getFailedOn();
                    }
                    return response;
                }
            };
            Map<byte[], VisibilityLabelsProtos.VisibilityLabelsResponse> result = table.coprocessorService(VisibilityLabelsProtos.VisibilityLabelsService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = result.values().iterator().next();
            return visibilityLabelsResponse;
        }
    }
}

