/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class TraceUtil {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.contrib.hbase";
    public static final AttributeKey<String> NAMESPACE_KEY = SemanticAttributes.DB_HBASE_NAMESPACE;
    public static final AttributeKey<String> TABLE_KEY = AttributeKey.stringKey((String)"db.hbase.table");
    public static final AttributeKey<List<String>> REGION_NAMES_KEY = AttributeKey.stringArrayKey((String)"db.hbase.regions");
    public static final AttributeKey<String> RPC_SERVICE_KEY = AttributeKey.stringKey((String)"db.hbase.rpc.service");
    public static final AttributeKey<String> RPC_METHOD_KEY = AttributeKey.stringKey((String)"db.hbase.rpc.method");
    public static final AttributeKey<String> SERVER_NAME_KEY = AttributeKey.stringKey((String)"db.hbase.server.name");
    public static final AttributeKey<String> REMOTE_HOST_KEY = SemanticAttributes.NET_PEER_NAME;
    public static final AttributeKey<Long> REMOTE_PORT_KEY = SemanticAttributes.NET_PEER_PORT;
    public static final AttributeKey<Boolean> ROW_LOCK_READ_LOCK_KEY = AttributeKey.booleanKey((String)"db.hbase.rowlock.readlock");
    public static final AttributeKey<String> WAL_IMPL = AttributeKey.stringKey((String)"db.hbase.wal.impl");

    private TraceUtil() {
    }

    public static Tracer getGlobalTracer() {
        return GlobalOpenTelemetry.getTracer((String)INSTRUMENTATION_NAME);
    }

    public static Span createSpan(String name) {
        return TraceUtil.createSpan(name, SpanKind.INTERNAL);
    }

    public static Span createTableSpan(String spanName, TableName tableName) {
        return TraceUtil.createSpan(spanName).setAttribute(NAMESPACE_KEY, (Object)tableName.getNamespaceAsString()).setAttribute(TABLE_KEY, (Object)tableName.getNameAsString());
    }

    private static Span createSpan(String name, SpanKind kind) {
        return TraceUtil.getGlobalTracer().spanBuilder(name).setSpanKind(kind).startSpan();
    }

    public static Span createRemoteSpan(String name, Context ctx) {
        return TraceUtil.getGlobalTracer().spanBuilder(name).setParent(ctx).setSpanKind(SpanKind.SERVER).startSpan();
    }

    public static Span createClientSpan(String name) {
        return TraceUtil.createSpan(name, SpanKind.CLIENT);
    }

    public static <T> CompletableFuture<T> tracedFuture(Supplier<CompletableFuture<T>> action, String spanName, TableName tableName) {
        Span span = TraceUtil.createTableSpan(spanName, tableName);
        try (Scope scope = span.makeCurrent();){
            CompletableFuture<T> future = action.get();
            TraceUtil.endSpan(future, span);
            CompletableFuture<T> completableFuture = future;
            return completableFuture;
        }
    }

    public static <T> CompletableFuture<T> tracedFuture(Supplier<CompletableFuture<T>> action, String spanName) {
        Span span = TraceUtil.createSpan(spanName);
        try (Scope scope = span.makeCurrent();){
            CompletableFuture<T> future = action.get();
            TraceUtil.endSpan(future, span);
            CompletableFuture<T> completableFuture = future;
            return completableFuture;
        }
    }

    public static <T> List<CompletableFuture<T>> tracedFutures(Supplier<List<CompletableFuture<T>>> action, String spanName, TableName tableName) {
        Span span = TraceUtil.createTableSpan(spanName, tableName);
        try (Scope scope = span.makeCurrent();){
            List<CompletableFuture<CompletableFuture>> futures = action.get();
            TraceUtil.endSpan(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])), span);
            List<CompletableFuture<CompletableFuture>> list = futures;
            return list;
        }
    }

    public static void setError(Span span, Throwable error) {
        span.recordException(error);
        span.setStatus(StatusCode.ERROR);
    }

    private static void endSpan(CompletableFuture<?> future, Span span) {
        FutureUtils.addListener(future, (resp, error) -> {
            if (error != null) {
                TraceUtil.setError(span, error);
            } else {
                span.setStatus(StatusCode.OK);
            }
            span.end();
        });
    }

    public static void trace(Runnable action, String spanName) {
        TraceUtil.trace(action, () -> TraceUtil.createSpan(spanName));
    }

    public static void trace(Runnable action, Supplier<Span> creator) {
        Span span = creator.get();
        try (Scope scope = span.makeCurrent();){
            action.run();
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable e) {
            TraceUtil.setError(span, e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T trace(Supplier<T> action, String spanName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T trace(IOExceptionCallable<T> callable, String spanName) throws IOException {
        return TraceUtil.trace(callable, () -> TraceUtil.createSpan(spanName));
    }

    /*
     * Exception decompiling
     */
    public static <T> T trace(IOExceptionCallable<T> callable, Supplier<Span> creator) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    public static interface IOExceptionCallable<V> {
        public V call() throws IOException;
    }
}

