/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.key;

import java.security.GeneralSecurityException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.provider.CamelliaProvider;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.key.DkKeyMaker;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Cmac;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Pbkdf;

public class CamelliaKeyMaker
extends DkKeyMaker {
    public CamelliaKeyMaker(CamelliaProvider encProvider) {
        super(encProvider);
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        return randomBits;
    }

    @Override
    public byte[] str2key(String string, String salt, byte[] param) throws KrbException {
        byte[] random;
        int iterCount = CamelliaKeyMaker.getIterCount(param, 32768);
        byte[] saltBytes = CamelliaKeyMaker.getSaltBytes(salt, this.getPepper());
        int keySize = this.encProvider().keySize();
        try {
            random = Pbkdf.pbkdf2(string.toCharArray(), saltBytes, iterCount, keySize);
        }
        catch (GeneralSecurityException e) {
            throw new KrbException("pbkdf2 failed", (Throwable)e);
        }
        byte[] tmpKey = this.random2Key(random);
        return this.dk(tmpKey, KERBEROS_CONSTANT);
    }

    private String getPepper() {
        int keySize = this.encProvider().keySize();
        return keySize == 16 ? "camellia128-cts-cmac" : "camellia256-cts-cmac";
    }

    @Override
    protected byte[] dr(byte[] key, byte[] constant) throws KrbException {
        int blocksize = this.encProvider().blockSize();
        int keyInuptSize = this.encProvider().keyInputSize();
        byte[] keyBytes = new byte[keyInuptSize];
        int len = 0;
        len += blocksize;
        len += 4;
        len += constant.length;
        ++len;
        byte[] ki = new byte[len += 4];
        System.arraycopy(constant, 0, ki, blocksize + 4, constant.length);
        BytesUtil.int2bytes(keyInuptSize * 8, ki, len - 4, true);
        int i = 1;
        int n = 0;
        while (n < keyInuptSize) {
            BytesUtil.int2bytes(i, ki, blocksize, true);
            byte[] tmp = Cmac.cmac(this.encProvider(), key, ki);
            System.arraycopy(tmp, 0, ki, 0, blocksize);
            if (n + blocksize >= keyInuptSize) {
                System.arraycopy(ki, 0, keyBytes, n, keyInuptSize - n);
                break;
            }
            System.arraycopy(ki, 0, keyBytes, n, blocksize);
            n += blocksize;
            ++i;
        }
        return keyBytes;
    }
}

