/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.provider;

import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;

public abstract class AbstractEncryptProvider
implements EncryptProvider {
    private int blockSize;
    private int keyInputSize;
    private int keySize;

    public AbstractEncryptProvider(int blockSize, int keyInputSize, int keySize) {
        this.blockSize = blockSize;
        this.keyInputSize = keyInputSize;
        this.keySize = keySize;
    }

    @Override
    public int keyInputSize() {
        return this.keyInputSize;
    }

    @Override
    public int keySize() {
        return this.keySize;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public void encrypt(byte[] key, byte[] cipherState, byte[] data) throws KrbException {
        this.doEncrypt(data, key, cipherState, true);
    }

    @Override
    public void decrypt(byte[] key, byte[] cipherState, byte[] data) throws KrbException {
        this.doEncrypt(data, key, cipherState, false);
    }

    @Override
    public void encrypt(byte[] key, byte[] data) throws KrbException {
        byte[] cipherState = new byte[this.blockSize()];
        this.encrypt(key, cipherState, data);
    }

    @Override
    public void decrypt(byte[] key, byte[] data) throws KrbException {
        byte[] cipherState = new byte[this.blockSize()];
        this.decrypt(key, cipherState, data);
    }

    protected abstract void doEncrypt(byte[] var1, byte[] var2, byte[] var3, boolean var4) throws KrbException;

    @Override
    public byte[] cbcMac(byte[] key, byte[] iv, byte[] data) throws KrbException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportCbcMac() {
        return false;
    }
}

