/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client.request;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOptions;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.client.request.AsRequest;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class AsRequestWithKeytab
extends AsRequest {
    public AsRequestWithKeytab(KrbContext context) {
        super(context);
        this.setAllowedPreauth(PaDataType.ENC_TIMESTAMP);
    }

    private Keytab getKeytab() {
        File keytabFile = null;
        KOptions kOptions = this.getRequestOptions();
        if (kOptions.contains(KrbOption.KEYTAB_FILE)) {
            keytabFile = kOptions.getFileOption(KrbOption.KEYTAB_FILE);
        }
        if (kOptions.contains(KrbOption.USE_DFT_KEYTAB)) {
            String clientKeytabEnv = System.getenv("KRB5_CLIENT_KTNAME");
            String clientKeytabDft = this.getContext().getConfig().getString("default_client_keytab_name");
            if (clientKeytabEnv != null) {
                keytabFile = new File(clientKeytabEnv);
            } else if (clientKeytabDft != null) {
                keytabFile = new File(clientKeytabDft);
            } else {
                System.err.println("Default client keytab file not found.");
            }
        }
        Keytab keytab = null;
        try {
            keytab = Keytab.loadKeytab(keytabFile);
        }
        catch (IOException e) {
            System.err.println("Can not load keytab from file" + keytabFile.getAbsolutePath());
        }
        return keytab;
    }

    @Override
    public EncryptionKey getClientKey() throws KrbException {
        if (super.getClientKey() == null) {
            EncryptionKey tmpKey = this.getKeytab().getKey(this.getClientPrincipal(), this.getChosenEncryptionType());
            this.setClientKey(tmpKey);
        }
        return super.getClientKey();
    }
}

