/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.config;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.ConfigImpl;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.ConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.Resource;

public class MapConfigLoader
extends ConfigLoader {
    @Override
    protected void loadConfig(ConfigImpl config, Resource resource) {
        Map mapConfig = (Map)resource.getResource();
        Iterator iter = mapConfig.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() instanceof String) {
                this.loadStringMap(config, mapConfig);
            } else {
                this.loadObjectMap(config, mapConfig);
            }
        }
    }

    private void loadStringMap(ConfigImpl config, Map<String, Object> stringMap) {
        for (Map.Entry<String, Object> entry : stringMap.entrySet()) {
            config.set(entry.getKey(), (String)entry.getValue());
        }
    }

    private void loadObjectMap(ConfigImpl config, Map<String, Object> objectMap) {
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                ConfigImpl subConfig = new ConfigImpl(key);
                this.loadSubmap(subConfig, (Map)value);
                config.add(subConfig);
                continue;
            }
            throw new RuntimeException("Unable to resolve config:" + key);
        }
    }

    private void loadSubmap(ConfigImpl config, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                config.set(key, (String)value);
            }
            if (!(value instanceof Map)) continue;
            ConfigImpl subConfig = new ConfigImpl(key);
            this.loadSubmap(subConfig, (Map)value);
            config.add(subConfig);
        }
    }
}

