/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Simple;

public class Asn1UtcTime
extends Asn1Simple<Date> {
    public Asn1UtcTime() {
        this((Date)null);
    }

    public Asn1UtcTime(long time) {
        super(UniversalTag.UTC_TIME, new Date(time * 1000L));
    }

    public Asn1UtcTime(Date date) {
        super(UniversalTag.UTC_TIME, date);
    }

    @Override
    protected void toValue() throws IOException {
        String dateStr = new String(this.getBytes(), StandardCharsets.US_ASCII);
        String fixedDateStr = dateStr;
        int strLen = fixedDateStr.length();
        if (strLen == 6) {
            fixedDateStr = fixedDateStr + "000000+0000";
        } else if (strLen == 7) {
            fixedDateStr = fixedDateStr.replace("Z", "000000+0000");
        } else if (strLen == 10) {
            fixedDateStr = fixedDateStr + "00+0000";
        } else if (strLen == 11) {
            fixedDateStr = fixedDateStr.replace("Z", "00+0000");
        } else if (strLen == 12) {
            fixedDateStr = fixedDateStr + "+0000";
        } else if (strLen == 13) {
            fixedDateStr = fixedDateStr.replace("Z", "+0000");
        } else if (strLen != 17) {
            throw new IllegalArgumentException("Bad utc time string " + dateStr);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmssZ");
        sdf.setTimeZone(new SimpleTimeZone(0, "Z"));
        try {
            this.setValue(sdf.parse(fixedDateStr));
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse " + dateStr + " as utc time", e);
        }
    }

    @Override
    protected void toBytes() {
        Date date = (Date)this.getValue();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss'Z'");
        sdf.setTimeZone(new SimpleTimeZone(0, "Z"));
        String str = sdf.format(date);
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        this.setBytes(bytes);
    }
}

