/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Binder;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Dumper;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.EnumType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Tag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.TaggingOption;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Type;

public class Asn1Choice
extends AbstractAsn1Type<Asn1Type>
implements Asn1Dumpable {
    private final Asn1FieldInfo[] fieldInfos;
    private final Tag[] tags;
    private Asn1FieldInfo chosenField;

    public Asn1Choice(Asn1FieldInfo[] fieldInfos) {
        super(UniversalTag.CHOICE);
        this.fieldInfos = fieldInfos;
        this.tags = new Tag[fieldInfos.length];
        this.initTags();
    }

    @Override
    public Tag tag() {
        if (this.getValue() != null) {
            return ((Asn1Type)this.getValue()).tag();
        }
        if (this.chosenField != null) {
            return this.chosenField.getFieldTag();
        }
        return super.tag();
    }

    private void initTags() {
        for (int i = 0; i < this.fieldInfos.length; ++i) {
            this.tags[i] = this.fieldInfos[i].getFieldTag();
        }
    }

    public boolean matchAndSetValue(Tag tag) {
        int foundPos = -1;
        for (int i = 0; i < this.fieldInfos.length; ++i) {
            if (tag.isContextSpecific()) {
                if (this.fieldInfos[i].getTagNo() != tag.tagNo()) continue;
                foundPos = i;
                break;
            }
            if (!this.tags[i].equals(tag)) continue;
            foundPos = i;
            break;
        }
        if (foundPos != -1) {
            this.chosenField = this.fieldInfos[foundPos];
            this.setValue(this.fieldInfos[foundPos].createFieldValue());
            return true;
        }
        return false;
    }

    @Override
    public byte[] encode() throws IOException {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue != null) {
            if (this.chosenField.isTagged()) {
                TaggingOption taggingOption = this.chosenField.getTaggingOption();
                return theValue.taggedEncode(taggingOption);
            }
            return theValue.encode();
        }
        return null;
    }

    @Override
    public void encode(ByteBuffer buffer) throws IOException {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue != null) {
            if (this.chosenField.isTagged()) {
                TaggingOption taggingOption = this.chosenField.getTaggingOption();
                theValue.taggedEncode(buffer, taggingOption);
            } else {
                theValue.encode(buffer);
            }
        }
    }

    @Override
    public int encodingLength() {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue != null) {
            if (this.chosenField.isTagged()) {
                TaggingOption taggingOption = this.chosenField.getTaggingOption();
                return theValue.taggedEncodingLength(taggingOption);
            }
            return theValue.encodingLength();
        }
        return super.encodingLength();
    }

    @Override
    protected int encodingBodyLength() {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue == null) {
            return 0;
        }
        return -1;
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue != null) {
            if (this.chosenField.isTagged()) {
                TaggingOption taggingOption = this.chosenField.getTaggingOption();
                theValue.taggedEncode(buffer, taggingOption);
            } else {
                theValue.encode(buffer);
            }
        }
    }

    @Override
    public void decode(ByteBuffer content) throws IOException {
        this.chosenField = null;
        this.setValue(null);
        super.decode(content);
    }

    @Override
    public void decode(Asn1ParseResult parseResult) throws IOException {
        if (this.chosenField == null) {
            this.matchAndSetValue(parseResult.tag());
        }
        this.decodeBody(parseResult);
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        if (this.chosenField == null) {
            this.matchAndSetValue(parseResult.tag());
        }
        if (this.chosenField == null) {
            throw new IOException("Unexpected item, not in choices: " + parseResult.simpleInfo());
        }
        Asn1Type fieldValue = (Asn1Type)this.getValue();
        if (parseResult.isContextSpecific()) {
            Asn1Binder.bindWithTagging(parseResult, fieldValue, this.chosenField.getTaggingOption());
        } else {
            Asn1Binder.bind(parseResult, fieldValue);
        }
    }

    protected <T extends Asn1Type> T getChoiceValueAs(EnumType index, Class<T> t) {
        if (this.chosenField == null || this.getValue() == null) {
            return null;
        }
        if (this.chosenField != null && index != this.chosenField.getIndex()) {
            throw new IllegalArgumentException("Incorrect chosen value requested");
        }
        return (T)((Asn1Type)this.getValue());
    }

    protected void setChoiceValue(EnumType index, Asn1Type value) {
        if (this.fieldInfos[index.getValue()].getIndex() != index) {
            throw new IllegalArgumentException("Incorrect choice option to set");
        }
        this.chosenField = this.fieldInfos[index.getValue()];
        this.setValue(value);
    }

    protected void setChoiceValueAsOctets(EnumType index, byte[] bytes) {
        Asn1OctetString value = new Asn1OctetString(bytes);
        this.setChoiceValue(index, value);
    }

    protected byte[] getChoiceValueAsOctets(EnumType index) {
        Asn1OctetString value = this.getChoiceValueAs(index, Asn1OctetString.class);
        if (value != null) {
            return (byte[])value.getValue();
        }
        return null;
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        Asn1Type theValue = (Asn1Type)this.getValue();
        dumper.indent(indents).append("<Choice>").newLine();
        dumper.dumpType(indents, theValue);
    }
}

