/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1;

import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.TagClass;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.UniversalTag;

public class Tag {
    private int tagFlags = 0;
    private int tagNo = 0;

    public Tag(int tag) {
        this.tagFlags = tag & 0xE0;
        this.tagNo = tag & 0x1F;
    }

    public Tag(UniversalTag tag) {
        this.tagFlags = TagClass.UNIVERSAL.getValue();
        this.tagNo = tag.getValue();
    }

    public Tag(int tagFlags, int tagNo) {
        this.tagFlags = tagFlags & 0xE0;
        this.tagNo = tagNo;
    }

    public Tag(TagClass tagClass, int tagNo) {
        this.tagFlags = tagClass.getValue();
        this.tagNo = tagNo;
    }

    public Tag(Tag other) {
        this(other.tagFlags, other.tagNo);
    }

    public TagClass tagClass() {
        return TagClass.fromTag(this.tagFlags);
    }

    public void usePrimitive(boolean isPrimitive) {
        this.tagFlags = isPrimitive ? (this.tagFlags &= 0xFFFFFFDF) : (this.tagFlags |= 0x20);
    }

    public boolean isPrimitive() {
        return (this.tagFlags & 0x20) == 0;
    }

    public int tagFlags() {
        return this.tagFlags;
    }

    public int tagNo() {
        return this.tagNo;
    }

    public UniversalTag universalTag() {
        if (this.isUniversal()) {
            return UniversalTag.fromValue(this.tagNo());
        }
        return UniversalTag.UNKNOWN;
    }

    public boolean isEOC() {
        return this.universalTag() == UniversalTag.EOC;
    }

    public boolean isNull() {
        return this.universalTag() == UniversalTag.NULL;
    }

    public boolean isUniversal() {
        return this.tagClass().isUniversal();
    }

    public boolean isAppSpecific() {
        return this.tagClass().isAppSpecific();
    }

    public boolean isContextSpecific() {
        return this.tagClass().isContextSpecific();
    }

    public boolean isSpecific() {
        return this.tagClass().isSpecific();
    }

    public byte tagByte() {
        int n = this.tagFlags | (this.tagNo < 31 ? this.tagNo : 31);
        return (byte)(n & 0xFF);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.tagFlags != tag.tagFlags) {
            return false;
        }
        return this.tagNo == tag.tagNo;
    }

    public int hashCode() {
        int result = this.tagFlags;
        result = 31 * result + this.tagNo;
        return result;
    }

    public String toString() {
        return String.format("0x%02X", this.tagByte());
    }

    public String typeStr() {
        if (this.isUniversal()) {
            return this.universalTag().toStr();
        }
        if (this.isAppSpecific()) {
            return "application [" + this.tagNo() + "]";
        }
        return "context [" + this.tagNo() + "]";
    }

    public static Tag newAppTag(int tagNo) {
        return new Tag(TagClass.APPLICATION, tagNo);
    }

    public static Tag newCtxTag(int tagNo) {
        return new Tag(TagClass.CONTEXT_SPECIFIC, tagNo);
    }
}

