/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface Connection
extends Abortable,
Closeable {
    public Configuration getConfiguration();

    default public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, null);
    }

    default public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.getTableBuilder(tableName, pool).build();
    }

    default public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams var1) throws IOException;

    public RegionLocator getRegionLocator(TableName var1) throws IOException;

    public void clearRegionLocationCache();

    public Admin getAdmin() throws IOException;

    @Override
    public void close() throws IOException;

    public boolean isClosed();

    public TableBuilder getTableBuilder(TableName var1, ExecutorService var2);

    public AsyncConnection toAsyncConnection();

    public String getClusterId();

    @InterfaceAudience.LimitedPrivate(value={"HBCK"})
    default public Hbck getHbck() throws IOException {
        return FutureUtils.get(this.toAsyncConnection().getHbck());
    }

    @InterfaceAudience.LimitedPrivate(value={"HBCK"})
    default public Hbck getHbck(ServerName masterServer) throws IOException {
        return this.toAsyncConnection().getHbck(masterServer);
    }
}

