/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Function;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CellUtil {
    private CellUtil() {
    }

    public static byte[] cloneRow(Cell cell) {
        byte[] output = new byte[cell.getRowLength()];
        CellUtil.copyRowTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneFamily(Cell cell) {
        byte[] output = new byte[cell.getFamilyLength()];
        CellUtil.copyFamilyTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneQualifier(Cell cell) {
        byte[] output = new byte[cell.getQualifierLength()];
        CellUtil.copyQualifierTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneValue(Cell cell) {
        byte[] output = new byte[cell.getValueLength()];
        CellUtil.copyValueTo(cell, output, 0);
        return output;
    }

    public static byte[] makeColumn(byte[] family, byte[] qualifier) {
        return Bytes.add(family, KeyValue.COLUMN_FAMILY_DELIM_ARRAY, qualifier);
    }

    public static byte[][] parseColumn(byte[] c) {
        int index = KeyValue.getDelimiter(c, 0, c.length, 58);
        if (index == -1) {
            return new byte[][]{c};
        }
        if (index == c.length - 1) {
            byte[] family = new byte[c.length - 1];
            System.arraycopy(c, 0, family, 0, family.length);
            return new byte[][]{family, HConstants.EMPTY_BYTE_ARRAY};
        }
        byte[][] result = new byte[2][];
        result[0] = new byte[index];
        System.arraycopy(c, 0, result[0], 0, index);
        int len = c.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(c, index + 1, result[1], 0, len);
        return result;
    }

    public static int copyRowTo(Cell cell, byte[] destination, int destinationOffset) {
        short rowLen = cell.getRowLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), destinationOffset, rowLen);
        } else {
            System.arraycopy(cell.getRowArray(), cell.getRowOffset(), destination, destinationOffset, rowLen);
        }
        return destinationOffset + rowLen;
    }

    public static int copyRowTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        short rowLen = cell.getRowLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferExtendedCell)cell).getRowByteBuffer(), destination, ((ByteBufferExtendedCell)cell).getRowPosition(), destinationOffset, rowLen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getRowArray(), cell.getRowOffset(), rowLen);
        }
        return destinationOffset + rowLen;
    }

    public static byte[] copyRow(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.copyOfRange(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), ((ByteBufferExtendedCell)cell).getRowPosition() + cell.getRowLength());
        }
        return Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
    }

    public static int copyFamilyTo(Cell cell, byte[] destination, int destinationOffset) {
        byte fLen = cell.getFamilyLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), destinationOffset, fLen);
        } else {
            System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), destination, destinationOffset, fLen);
        }
        return destinationOffset + fLen;
    }

    public static int copyFamilyTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        byte fLen = cell.getFamilyLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), destination, ((ByteBufferExtendedCell)cell).getFamilyPosition(), destinationOffset, fLen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
        }
        return destinationOffset + fLen;
    }

    public static int copyQualifierTo(Cell cell, byte[] destination, int destinationOffset) {
        int qlen = cell.getQualifierLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), destinationOffset, qlen);
        } else {
            System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), destination, destinationOffset, qlen);
        }
        return destinationOffset + qlen;
    }

    public static int copyQualifierTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int qlen = cell.getQualifierLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), destination, ((ByteBufferExtendedCell)cell).getQualifierPosition(), destinationOffset, qlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getQualifierArray(), cell.getQualifierOffset(), qlen);
        }
        return destinationOffset + qlen;
    }

    public static int copyValueTo(Cell cell, byte[] destination, int destinationOffset) {
        int vlen = cell.getValueLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition(), destinationOffset, vlen);
        } else {
            System.arraycopy(cell.getValueArray(), cell.getValueOffset(), destination, destinationOffset, vlen);
        }
        return destinationOffset + vlen;
    }

    public static int copyValueTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int vlen = cell.getValueLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferExtendedCell)cell).getValueByteBuffer(), destination, ((ByteBufferExtendedCell)cell).getValuePosition(), destinationOffset, vlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getValueArray(), cell.getValueOffset(), vlen);
        }
        return destinationOffset + vlen;
    }

    public static CellScanner createCellScanner(final List<? extends CellScannable> cellScannerables) {
        return new CellScanner(){
            private final Iterator<? extends CellScannable> iterator;
            private CellScanner cellScanner;
            {
                this.iterator = cellScannerables.iterator();
                this.cellScanner = null;
            }

            @Override
            public Cell current() {
                return this.cellScanner != null ? this.cellScanner.current() : null;
            }

            @Override
            public boolean advance() throws IOException {
                while (true) {
                    if (this.cellScanner == null) {
                        if (!this.iterator.hasNext()) {
                            return false;
                        }
                        this.cellScanner = this.iterator.next().cellScanner();
                    }
                    if (this.cellScanner.advance()) {
                        return true;
                    }
                    this.cellScanner = null;
                }
            }
        };
    }

    public static CellScanner createCellScanner(Iterable<Cell> cellIterable) {
        if (cellIterable == null) {
            return null;
        }
        return CellUtil.createCellScanner(cellIterable.iterator());
    }

    public static CellScanner createCellScanner(final Iterator<Cell> cells) {
        if (cells == null) {
            return null;
        }
        return new CellScanner(){
            private final Iterator<Cell> iterator;
            private Cell current;
            {
                this.iterator = cells;
                this.current = null;
            }

            @Override
            public Cell current() {
                return this.current;
            }

            @Override
            public boolean advance() {
                boolean hasNext = this.iterator.hasNext();
                this.current = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        };
    }

    public static CellScanner createCellScanner(final Cell[] cellArray) {
        return new CellScanner(){
            private final Cell[] cells;
            private int index;
            {
                this.cells = cellArray;
                this.index = -1;
            }

            @Override
            public Cell current() {
                if (this.cells == null) {
                    return null;
                }
                return this.index < 0 ? null : this.cells[this.index];
            }

            @Override
            public boolean advance() {
                if (this.cells == null) {
                    return false;
                }
                return ++this.index < this.cells.length;
            }
        };
    }

    public static CellScanner createCellScanner(final NavigableMap<byte[], List<Cell>> map) {
        return new CellScanner(){
            private final Iterator<Map.Entry<byte[], List<Cell>>> entries;
            private Iterator<Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = map.entrySet().iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                while (true) {
                    if (this.currentIterator == null) {
                        if (!this.entries.hasNext()) {
                            return false;
                        }
                        this.currentIterator = this.entries.next().getValue().iterator();
                    }
                    if (this.currentIterator.hasNext()) {
                        this.currentCell = this.currentIterator.next();
                        return true;
                    }
                    this.currentCell = null;
                    this.currentIterator = null;
                }
            }
        };
    }

    public static boolean matchingRows(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getRowLength() == 0;
        }
        return PrivateCellUtil.matchingRows(left, buf, 0, buf.length);
    }

    public static boolean matchingRow(Cell left, byte[] buf, int offset, int length) {
        return PrivateCellUtil.matchingRows(left, buf, offset, length);
    }

    public static boolean matchingFamily(Cell left, Cell right) {
        byte lfamlength = left.getFamilyLength();
        byte rfamlength = right.getFamilyLength();
        return CellUtil.matchingFamily(left, lfamlength, right, rfamlength);
    }

    public static boolean matchingFamily(Cell left, byte lfamlength, Cell right, byte rfamlength) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)lfamlength, ((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)rfamlength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)lfamlength, right.getFamilyArray(), right.getFamilyOffset(), (int)rfamlength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)right).getFamilyByteBuffer(), ((ByteBufferExtendedCell)right).getFamilyPosition(), (int)rfamlength, left.getFamilyArray(), left.getFamilyOffset(), (int)lfamlength);
        }
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), lfamlength, right.getFamilyArray(), right.getFamilyOffset(), rfamlength);
    }

    public static boolean matchingFamily(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getFamilyLength() == 0;
        }
        return PrivateCellUtil.matchingFamily(left, buf, 0, buf.length);
    }

    public static boolean matchingQualifier(Cell left, Cell right) {
        int lqlength = left.getQualifierLength();
        int rqlength = right.getQualifierLength();
        return CellUtil.matchingQualifier(left, lqlength, right, rqlength);
    }

    private static boolean matchingQualifier(Cell left, int lqlength, Cell right, int rqlength) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), lqlength, ((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), rqlength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)right).getQualifierByteBuffer(), ((ByteBufferExtendedCell)right).getQualifierPosition(), rqlength, left.getQualifierArray(), left.getQualifierOffset(), lqlength);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
    }

    public static boolean matchingQualifier(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        return PrivateCellUtil.matchingQualifier(left, buf, 0, buf.length);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, byte[] qual) {
        return CellUtil.matchingFamily(left, fam) && CellUtil.matchingQualifier(left, qual);
    }

    public static boolean matchingColumnFamilyAndQualifierPrefix(Cell left, byte[] fam, byte[] qual) {
        return CellUtil.matchingFamily(left, fam) && PrivateCellUtil.qualifierStartsWith(left, qual);
    }

    public static boolean matchingColumn(Cell left, Cell right) {
        if (!CellUtil.matchingFamily(left, right)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, right);
    }

    private static boolean matchingColumn(Cell left, byte lFamLen, int lQualLength, Cell right, byte rFamLen, int rQualLength) {
        if (!CellUtil.matchingFamily(left, lFamLen, right, rFamLen)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, lQualLength, right, rQualLength);
    }

    public static boolean matchingValue(Cell left, Cell right) {
        return CellUtil.matchingValue(left, right, left.getValueLength(), right.getValueLength());
    }

    public static boolean matchingValue(Cell left, Cell right, int lvlength, int rvlength) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getValueByteBuffer(), ((ByteBufferExtendedCell)left).getValuePosition(), lvlength, ((ByteBufferExtendedCell)right).getValueByteBuffer(), ((ByteBufferExtendedCell)right).getValuePosition(), rvlength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getValueByteBuffer(), ((ByteBufferExtendedCell)left).getValuePosition(), lvlength, right.getValueArray(), right.getValueOffset(), rvlength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)right).getValueByteBuffer(), ((ByteBufferExtendedCell)right).getValuePosition(), rvlength, left.getValueArray(), left.getValueOffset(), lvlength);
        }
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), lvlength, right.getValueArray(), right.getValueOffset(), rvlength);
    }

    public static boolean matchingValue(Cell left, byte[] buf) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getValueByteBuffer(), ((ByteBufferExtendedCell)left).getValuePosition(), left.getValueLength(), buf, 0, buf.length) == 0;
        }
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), buf, 0, buf.length);
    }

    public static boolean matchingTags(Cell left, Cell right) {
        return PrivateCellUtil.matchingTags(left, right, left.getTagsLength(), right.getTagsLength());
    }

    public static boolean isDelete(Cell cell) {
        return PrivateCellUtil.isDelete(cell.getTypeByte());
    }

    public static boolean isPut(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Put.getCode();
    }

    @InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
    public static void setTimestamp(Cell cell, long ts) throws IOException {
        PrivateCellUtil.setTimestamp(cell, ts);
    }

    @InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
    public static void setTimestamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        PrivateCellUtil.setTimestamp(cell, Bytes.toLong(ts, tsOffset));
    }

    public static String getCellKeyAsString(Cell cell) {
        return CellUtil.getCellKeyAsString(cell, c -> Bytes.toStringBinary(c.getRowArray(), c.getRowOffset(), c.getRowLength()));
    }

    public static String getCellKeyAsString(Cell cell, Function<Cell, String> rowConverter) {
        StringBuilder sb = new StringBuilder(rowConverter.apply(cell));
        sb.append('/');
        sb.append(cell.getFamilyLength() == 0 ? "" : Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
        if (cell.getFamilyLength() > 0) {
            sb.append(':');
        }
        sb.append(cell.getQualifierLength() == 0 ? "" : Bytes.toStringBinary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
        sb.append('/');
        sb.append(KeyValue.humanReadableTimestamp(cell.getTimestamp()));
        sb.append('/');
        sb.append((Object)KeyValue.Type.codeToType(cell.getTypeByte()));
        if (!(cell instanceof KeyValue.KeyOnlyKeyValue)) {
            sb.append("/vlen=");
            sb.append(cell.getValueLength());
        }
        sb.append("/seqid=");
        sb.append(cell.getSequenceId());
        return sb.toString();
    }

    public static String toString(Cell cell, boolean verbose) {
        if (cell == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String keyStr = CellUtil.getCellKeyAsString(cell);
        String tag = null;
        String value = null;
        if (verbose) {
            if (cell.getTagsLength() > 0) {
                tag = Bytes.toStringBinary(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            }
            if (!(cell instanceof KeyValue.KeyOnlyKeyValue)) {
                value = Bytes.toStringBinary(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            }
        }
        builder.append(keyStr);
        if (tag != null && !tag.isEmpty()) {
            builder.append("/").append(tag);
        }
        if (value != null) {
            builder.append("/").append(value);
        }
        return builder.toString();
    }

    public static boolean equals(Cell a, Cell b) {
        return CellUtil.matchingRows(a, b) && CellUtil.matchingFamily(a, b) && CellUtil.matchingQualifier(a, b) && CellUtil.matchingTimestamp(a, b) && PrivateCellUtil.matchingType(a, b);
    }

    public static boolean matchingTimestamp(Cell a, Cell b) {
        return CellComparator.getInstance().compareTimestamps(a.getTimestamp(), b.getTimestamp()) == 0;
    }

    public static boolean matchingRows(Cell left, Cell right) {
        short lrowlength = left.getRowLength();
        short rrowlength = right.getRowLength();
        return CellUtil.matchingRows(left, lrowlength, right, rrowlength);
    }

    public static boolean matchingRows(Cell left, short lrowlength, Cell right, short rrowlength) {
        if (lrowlength != rrowlength) {
            return false;
        }
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)lrowlength, ((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), (int)rrowlength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)lrowlength, right.getRowArray(), right.getRowOffset(), (int)rrowlength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)right).getRowByteBuffer(), ((ByteBufferExtendedCell)right).getRowPosition(), (int)rrowlength, left.getRowArray(), left.getRowOffset(), (int)lrowlength);
        }
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), lrowlength, right.getRowArray(), right.getRowOffset(), rrowlength);
    }

    public static boolean matchingRowColumn(Cell left, Cell right) {
        int rqlength;
        byte rfamlength;
        short rrowlength;
        short lrowlength = left.getRowLength();
        if (lrowlength != (rrowlength = right.getRowLength())) {
            return false;
        }
        byte lfamlength = left.getFamilyLength();
        if (lfamlength != (rfamlength = right.getFamilyLength())) {
            return false;
        }
        int lqlength = left.getQualifierLength();
        if (lqlength != (rqlength = right.getQualifierLength())) {
            return false;
        }
        if (!CellUtil.matchingRows(left, lrowlength, right, rrowlength)) {
            return false;
        }
        return CellUtil.matchingColumn(left, lfamlength, lqlength, right, rfamlength, rqlength);
    }

    public static boolean matchingRowColumnBytes(Cell left, Cell right) {
        short lrowlength = left.getRowLength();
        short rrowlength = right.getRowLength();
        byte lfamlength = left.getFamilyLength();
        byte rfamlength = right.getFamilyLength();
        int lqlength = left.getQualifierLength();
        int rqlength = right.getQualifierLength();
        if (lrowlength != rrowlength || lfamlength != rfamlength || lqlength != rqlength) {
            return false;
        }
        if (!Bytes.equals(left.getRowArray(), left.getRowOffset(), lrowlength, right.getRowArray(), right.getRowOffset(), rrowlength)) {
            return false;
        }
        if (!Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), lfamlength, right.getFamilyArray(), right.getFamilyOffset(), rfamlength)) {
            return false;
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), lqlength, right.getQualifierArray(), right.getQualifierOffset(), rqlength);
    }

    public static final int compareQualifiers(Cell left, byte[] right, int rOffset, int rLength) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), right, rOffset, rLength);
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right, rOffset, rLength);
    }

    public static final int compareFamilies(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.compareTo(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), right, roffset, rlength);
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right, roffset, rlength);
    }

    public static final int compareColumns(Cell left, byte[] right, int rfoffset, int rflength, int rqoffset, int rqlength) {
        int diff = CellUtil.compareFamilies(left, right, rfoffset, rflength);
        if (diff != 0) {
            return diff;
        }
        return CellUtil.compareQualifiers(left, right, rqoffset, rqlength);
    }
}

