/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.RetryLoop;
import org.apache.hadoop.hbase.shaded.org.apache.curator.drivers.OperationTrace;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.StatPathable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.TempGetDataBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;

class TempGetDataBuilderImpl
implements TempGetDataBuilder {
    private final CuratorFrameworkImpl client;
    private Stat responseStat;
    private boolean decompress;

    TempGetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.responseStat = null;
        this.decompress = false;
    }

    @Override
    public StatPathable<byte[]> decompressed() {
        this.decompress = true;
        return this;
    }

    @Override
    public Pathable<byte[]> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return this;
    }

    @Override
    public byte[] forPath(String path) throws Exception {
        final String localPath = this.client.fixForNamespace(path);
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("GetDataBuilderImpl-Foreground");
        byte[] responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return TempGetDataBuilderImpl.this.client.getZooKeeper().getData(localPath, false, TempGetDataBuilderImpl.this.responseStat);
            }
        });
        trace.setResponseBytesLength(responseData).setPath(path).setStat(this.responseStat).commit();
        return this.decompress ? this.client.getCompressionProvider().decompress(path, responseData) : responseData;
    }
}

