/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.AlgorithmSupportMessage;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.BaseJWEProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.ConcatKDF;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.crypto.ContentCryptoProvider;
import org.apache.hadoop.hbase.shaded.com.nimbusds.jose.jwk.ECKey;

abstract class ECDHCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    public static final Set<ECKey.Curve> SUPPORTED_ELLIPTIC_CURVES;
    private final ECKey.Curve curve;
    private final ConcatKDF concatKDF;

    static {
        SUPPORTED_ENCRYPTION_METHODS = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
        LinkedHashSet<JWEAlgorithm> algs = new LinkedHashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.ECDH_ES);
        algs.add(JWEAlgorithm.ECDH_ES_A128KW);
        algs.add(JWEAlgorithm.ECDH_ES_A192KW);
        algs.add(JWEAlgorithm.ECDH_ES_A256KW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
        LinkedHashSet<ECKey.Curve> curves = new LinkedHashSet<ECKey.Curve>();
        curves.add(ECKey.Curve.P_256);
        curves.add(ECKey.Curve.P_384);
        curves.add(ECKey.Curve.P_521);
        SUPPORTED_ELLIPTIC_CURVES = Collections.unmodifiableSet(curves);
    }

    protected ECDHCryptoProvider(ECKey.Curve curve) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        ECKey.Curve definedCurve;
        ECKey.Curve curve2 = definedCurve = curve != null ? curve : new ECKey.Curve("unknown");
        if (!SUPPORTED_ELLIPTIC_CURVES.contains(curve)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEllipticCurve(definedCurve, SUPPORTED_ELLIPTIC_CURVES));
        }
        this.curve = curve;
        this.concatKDF = new ConcatKDF("SHA-256");
    }

    protected ConcatKDF getConcatKDF() {
        return this.concatKDF;
    }

    public Set<ECKey.Curve> supportedEllipticCurves() {
        return SUPPORTED_ELLIPTIC_CURVES;
    }

    public ECKey.Curve getCurve() {
        return this.curve;
    }
}

