/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncAdminBuilderBase;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilderImpl;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.hadoop.hbase.client.AsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hadoop.hbase.client.AsyncTableImpl;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocatorImpl;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HBaseHbck;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RawAsyncTableImpl;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicyFactory;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncConnectionImpl
implements AsyncConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectionImpl.class);
    @VisibleForTesting
    static final HashedWheelTimer RETRY_TIMER = new HashedWheelTimer(Threads.newDaemonThreadFactory("Async-Client-Retry-Timer"), 10L, TimeUnit.MILLISECONDS);
    private static final String RESOLVE_HOSTNAME_ON_FAIL_KEY = "hbase.resolve.hostnames.on.failure";
    private final Configuration conf;
    final AsyncConnectionConfiguration connConf;
    private final User user;
    final AsyncRegistry registry;
    private final int rpcTimeout;
    private final RpcClient rpcClient;
    final RpcControllerFactory rpcControllerFactory;
    private final boolean hostnameCanChange;
    private final AsyncRegionLocator locator;
    final AsyncRpcRetryingCallerFactory callerFactory;
    private final NonceGenerator nonceGenerator;
    private final ConcurrentMap<String, ClientProtos.ClientService.Interface> rsStubs = new ConcurrentHashMap<String, ClientProtos.ClientService.Interface>();
    private final ConcurrentMap<String, AdminProtos.AdminService.Interface> adminSubs = new ConcurrentHashMap<String, AdminProtos.AdminService.Interface>();
    private final AtomicReference<MasterProtos.MasterService.Interface> masterStub = new AtomicReference();
    private final AtomicReference<CompletableFuture<MasterProtos.MasterService.Interface>> masterStubMakeFuture = new AtomicReference();
    private final Optional<ServerStatisticTracker> stats;
    private final ClientBackoffPolicy backoffPolicy;
    private ChoreService authService;
    private volatile boolean closed = false;
    private final Optional<MetricsConnection> metrics;
    private final ClusterStatusListener clusterStatusListener;

    public AsyncConnectionImpl(Configuration conf, AsyncRegistry registry, String clusterId, User user) {
        this.conf = conf;
        this.user = user;
        if (user.isLoginFromKeytab()) {
            this.spawnRenewalChore(user.getUGI());
        }
        this.connConf = new AsyncConnectionConfiguration(conf);
        this.registry = registry;
        this.metrics = conf.getBoolean("hbase.client.metrics.enable", false) ? Optional.of(new MetricsConnection(this.toString(), () -> null, () -> null)) : Optional.empty();
        this.rpcClient = RpcClientFactory.createClient(conf, clusterId, this.metrics.orElse(null));
        this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
        this.hostnameCanChange = conf.getBoolean(RESOLVE_HOSTNAME_ON_FAIL_KEY, true);
        this.rpcTimeout = (int)Math.min(Integer.MAX_VALUE, TimeUnit.NANOSECONDS.toMillis(this.connConf.getRpcTimeoutNs()));
        this.locator = new AsyncRegionLocator(this, RETRY_TIMER);
        this.callerFactory = new AsyncRpcRetryingCallerFactory(this, RETRY_TIMER);
        this.nonceGenerator = conf.getBoolean("hbase.client.nonces.enabled", true) ? PerClientRandomNonceGenerator.get() : ConnectionUtils.NO_NONCE_GENERATOR;
        this.stats = Optional.ofNullable(ServerStatisticTracker.create(conf));
        this.backoffPolicy = ClientBackoffPolicyFactory.create(conf);
        ClusterStatusListener listener = null;
        if (conf.getBoolean("hbase.status.published", false)) {
            Class<ClusterStatusListener.Listener> listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
            if (listenerClass == null) {
                LOG.warn("{} is true, but {} is not set", (Object)"hbase.status.published", (Object)"hbase.status.listener.class");
            } else {
                try {
                    listener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                        @Override
                        public void newDead(ServerName sn) {
                            AsyncConnectionImpl.this.locator.clearCache(sn);
                            AsyncConnectionImpl.this.rpcClient.cancelConnections(sn);
                        }
                    }, conf, listenerClass);
                }
                catch (IOException e) {
                    LOG.warn("Failed create of ClusterStatusListener, not a critical, ignoring...", (Throwable)e);
                }
            }
        }
        this.clusterStatusListener = listener;
    }

    private void spawnRenewalChore(UserGroupInformation user) {
        this.authService = new ChoreService("Relogin service");
        this.authService.scheduleChore(AuthUtil.getAuthRenewalChore(user));
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        LOG.info("Connection has been closed by {}.", (Object)Thread.currentThread().getName());
        if (LOG.isDebugEnabled()) {
            this.logCallStack(Thread.currentThread().getStackTrace());
        }
        IOUtils.closeQuietly((Closeable)this.clusterStatusListener);
        IOUtils.closeQuietly((Closeable)this.rpcClient);
        IOUtils.closeQuietly((Closeable)this.registry);
        if (this.authService != null) {
            this.authService.shutdown();
        }
        this.metrics.ifPresent(MetricsConnection::shutdown);
        this.closed = true;
    }

    private void logCallStack(StackTraceElement[] stackTraceElements) {
        StringBuilder stackBuilder = new StringBuilder("Call stack:");
        for (StackTraceElement element : stackTraceElements) {
            stackBuilder.append("\n    at ");
            stackBuilder.append(element);
        }
        stackBuilder.append("\n");
        LOG.debug(stackBuilder.toString());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public AsyncTableRegionLocator getRegionLocator(TableName tableName) {
        return new AsyncTableRegionLocatorImpl(tableName, this);
    }

    AsyncRegionLocator getLocator() {
        return this.locator;
    }

    @VisibleForTesting
    public NonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    private ClientProtos.ClientService.Interface createRegionServerStub(ServerName serverName) throws IOException {
        return ClientProtos.ClientService.newStub(this.rpcClient.createRpcChannel(serverName, this.user, this.rpcTimeout));
    }

    ClientProtos.ClientService.Interface getRegionServerStub(ServerName serverName) throws IOException {
        return ConcurrentMapUtils.computeIfAbsentEx(this.rsStubs, ConnectionUtils.getStubKey(ClientProtos.ClientService.Interface.class.getSimpleName(), serverName, this.hostnameCanChange), () -> this.createRegionServerStub(serverName));
    }

    private MasterProtos.MasterService.Interface createMasterStub(ServerName serverName) throws IOException {
        return MasterProtos.MasterService.newStub(this.rpcClient.createRpcChannel(serverName, this.user, this.rpcTimeout));
    }

    private AdminProtos.AdminService.Interface createAdminServerStub(ServerName serverName) throws IOException {
        return AdminProtos.AdminService.newStub(this.rpcClient.createRpcChannel(serverName, this.user, this.rpcTimeout));
    }

    AdminProtos.AdminService.Interface getAdminStub(ServerName serverName) throws IOException {
        return ConcurrentMapUtils.computeIfAbsentEx(this.adminSubs, ConnectionUtils.getStubKey(AdminProtos.AdminService.Interface.class.getSimpleName(), serverName, this.hostnameCanChange), () -> this.createAdminServerStub(serverName));
    }

    CompletableFuture<MasterProtos.MasterService.Interface> getMasterStub() {
        return ConnectionUtils.getOrFetch(this.masterStub, this.masterStubMakeFuture, false, () -> {
            CompletableFuture future = new CompletableFuture();
            FutureUtils.addListener(this.registry.getMasterAddress(), (addr, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                } else if (addr == null) {
                    future.completeExceptionally(new MasterNotRunningException("ZooKeeper available but no active master location found"));
                } else {
                    LOG.debug("The fetched master address is {}", addr);
                    try {
                        future.complete(this.createMasterStub((ServerName)addr));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            });
            return future;
        }, stub -> true, "master stub");
    }

    void clearMasterStubCache(MasterProtos.MasterService.Interface stub) {
        this.masterStub.compareAndSet(stub, null);
    }

    Optional<ServerStatisticTracker> getStatisticsTracker() {
        return this.stats;
    }

    ClientBackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    @Override
    public AsyncTableBuilder<AdvancedScanResultConsumer> getTableBuilder(TableName tableName) {
        return new AsyncTableBuilderBase<AdvancedScanResultConsumer>(tableName, this.connConf){

            @Override
            public AsyncTable<AdvancedScanResultConsumer> build() {
                return new RawAsyncTableImpl(AsyncConnectionImpl.this, RETRY_TIMER, this);
            }
        };
    }

    @Override
    public AsyncTableBuilder<ScanResultConsumer> getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new AsyncTableBuilderBase<ScanResultConsumer>(tableName, this.connConf){

            @Override
            public AsyncTable<ScanResultConsumer> build() {
                RawAsyncTableImpl rawTable = new RawAsyncTableImpl(AsyncConnectionImpl.this, RETRY_TIMER, this);
                return new AsyncTableImpl(AsyncConnectionImpl.this, rawTable, pool);
            }
        };
    }

    @Override
    public AsyncAdminBuilder getAdminBuilder() {
        return new AsyncAdminBuilderBase(this.connConf){

            @Override
            public AsyncAdmin build() {
                return new RawAsyncHBaseAdmin(AsyncConnectionImpl.this, RETRY_TIMER, this);
            }
        };
    }

    @Override
    public AsyncAdminBuilder getAdminBuilder(final ExecutorService pool) {
        return new AsyncAdminBuilderBase(this.connConf){

            @Override
            public AsyncAdmin build() {
                RawAsyncHBaseAdmin rawAdmin = new RawAsyncHBaseAdmin(AsyncConnectionImpl.this, RETRY_TIMER, this);
                return new AsyncHBaseAdmin(rawAdmin, pool);
            }
        };
    }

    @Override
    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName) {
        return new AsyncBufferedMutatorBuilderImpl(this.connConf, this.getTableBuilder(tableName), RETRY_TIMER);
    }

    @Override
    public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName, ExecutorService pool) {
        return new AsyncBufferedMutatorBuilderImpl(this.connConf, this.getTableBuilder(tableName, pool), RETRY_TIMER);
    }

    @Override
    public CompletableFuture<Hbck> getHbck() {
        CompletableFuture<Hbck> future = new CompletableFuture<Hbck>();
        FutureUtils.addListener(this.registry.getMasterAddress(), (sn, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
            } else {
                try {
                    future.complete(this.getHbck((ServerName)sn));
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
            }
        });
        return future;
    }

    @Override
    public Hbck getHbck(ServerName masterServer) throws IOException {
        return new HBaseHbck(MasterProtos.HbckService.newBlockingStub(this.rpcClient.createBlockingRpcChannel(masterServer, this.user, this.rpcTimeout)), this.rpcControllerFactory);
    }

    @Override
    public void clearRegionLocationCache() {
        this.locator.clearCache();
    }

    Optional<MetricsConnection> getConnectionMetrics() {
        return this.metrics;
    }
}

