/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ftp.FTPException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.net.ftp.FTPClient;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FTPInputStream
extends FSInputStream {
    InputStream wrappedStream;
    FTPClient client;
    FileSystem.Statistics stats;
    boolean closed;
    long pos;

    public FTPInputStream(InputStream stream, FTPClient client, FileSystem.Statistics stats) {
        if (stream == null) {
            throw new IllegalArgumentException("Null InputStream");
        }
        if (client == null || !client.isConnected()) {
            throw new IllegalArgumentException("FTP client null or not connected");
        }
        this.wrappedStream = stream;
        this.client = client;
        this.stats = stats;
        this.pos = 0L;
        this.closed = false;
    }

    @Override
    public long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new IOException("Seek not supported");
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException("Seek not supported");
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int byteRead = this.wrappedStream.read();
        if (byteRead >= 0) {
            ++this.pos;
        }
        if (this.stats != null && byteRead >= 0) {
            this.stats.incrementBytesRead(1L);
        }
        return byteRead;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        int result = this.wrappedStream.read(buf, off, len);
        if (result > 0) {
            this.pos += (long)result;
        }
        if (this.stats != null && result > 0) {
            this.stats.incrementBytesRead(result);
        }
        return result;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        if (!this.client.isConnected()) {
            throw new FTPException("Client not connected");
        }
        boolean cmdCompleted = this.client.completePendingCommand();
        this.client.logout();
        this.client.disconnect();
        if (!cmdCompleted) {
            throw new FTPException("Could not complete transfer, Reply Code - " + this.client.getReplyCode());
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }
}

