/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.api.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.util.ComponentsMonitor;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.util.MandatoryComponentsMonitor;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.util.OptionalComponentsMonitor;

public class MandatoryAndOptionalComponentsMonitor
implements ComponentsMonitor {
    private ComponentsMonitor mandatoryComponentsMonitor;
    private ComponentsMonitor optionalComponentsMonitor;

    public MandatoryAndOptionalComponentsMonitor(String[] mandatoryComponents, String[] optionalComponents) throws IllegalArgumentException {
        for (int i = 0; i < mandatoryComponents.length; ++i) {
            for (int j = 0; j < optionalComponents.length; ++j) {
                if (!mandatoryComponents[i].equals(optionalComponents[j])) continue;
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04415, (Object[])new Object[]{mandatoryComponents[i]}));
            }
        }
        this.mandatoryComponentsMonitor = new MandatoryComponentsMonitor(mandatoryComponents);
        this.optionalComponentsMonitor = new OptionalComponentsMonitor(optionalComponents);
    }

    @Override
    public ComponentsMonitor useComponent(String component) {
        try {
            this.mandatoryComponentsMonitor.useComponent(component);
        }
        catch (IllegalArgumentException e1) {
            try {
                this.optionalComponentsMonitor.useComponent(component);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04416, (Object[])new Object[]{component}));
            }
        }
        return this;
    }

    @Override
    public boolean allComponentsUsed() {
        return this.mandatoryComponentsMonitor.allComponentsUsed() && this.optionalComponentsMonitor.allComponentsUsed();
    }

    @Override
    public boolean finalStateValid() {
        return this.mandatoryComponentsMonitor.finalStateValid() && this.optionalComponentsMonitor.finalStateValid();
    }

    @Override
    public List<String> getRemainingComponents() {
        LinkedList<String> remainingComponents = new LinkedList<String>();
        remainingComponents.addAll(this.mandatoryComponentsMonitor.getRemainingComponents());
        remainingComponents.addAll(this.optionalComponentsMonitor.getRemainingComponents());
        return Collections.unmodifiableList(remainingComponents);
    }
}

