/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FSProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ClusterMetricsBuilder {
    @Nullable
    private String hbaseVersion;
    private List<ServerName> deadServerNames = Collections.emptyList();
    private Map<ServerName, ServerMetrics> liveServerMetrics = new TreeMap<ServerName, ServerMetrics>();
    @Nullable
    private ServerName masterName;
    private List<ServerName> backupMasterNames = Collections.emptyList();
    private List<RegionState> regionsInTransition = Collections.emptyList();
    @Nullable
    private String clusterId;
    private List<String> masterCoprocessorNames = Collections.emptyList();
    @Nullable
    private Boolean balancerOn;
    private int masterInfoPort;
    private Map<TableName, RegionStatesCount> tableRegionStatesCount = Collections.emptyMap();

    public static ClusterStatusProtos.ClusterStatus toClusterStatus(ClusterMetrics metrics) {
        ClusterStatusProtos.ClusterStatus.Builder builder = ClusterStatusProtos.ClusterStatus.newBuilder().addAllBackupMasters(metrics.getBackupMasterNames().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList())).addAllDeadServers(metrics.getDeadServerNames().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList())).addAllLiveServers(metrics.getLiveServerMetrics().entrySet().stream().map(s -> ClusterStatusProtos.LiveServerInfo.newBuilder().setServer(ProtobufUtil.toServerName((ServerName)s.getKey())).setServerLoad(ServerMetricsBuilder.toServerLoad((ServerMetrics)s.getValue())).build()).collect(Collectors.toList())).addAllMasterCoprocessors(metrics.getMasterCoprocessorNames().stream().map(n -> HBaseProtos.Coprocessor.newBuilder().setName((String)n).build()).collect(Collectors.toList())).addAllRegionsInTransition(metrics.getRegionStatesInTransition().stream().map(r -> ClusterStatusProtos.RegionInTransition.newBuilder().setSpec(HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).setValue(UnsafeByteOperations.unsafeWrap(r.getRegion().getRegionName())).build()).setRegionState(r.convert()).build()).collect(Collectors.toList())).setMasterInfoPort(metrics.getMasterInfoPort()).addAllTableRegionStatesCount(metrics.getTableRegionStatesCount().entrySet().stream().map(status -> ClusterStatusProtos.TableRegionStatesCount.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)status.getKey())).setRegionStatesCount(ProtobufUtil.toTableRegionStatesCount((RegionStatesCount)status.getValue())).build()).collect(Collectors.toList()));
        if (metrics.getMasterName() != null) {
            builder.setMaster(ProtobufUtil.toServerName(metrics.getMasterName()));
        }
        if (metrics.getBalancerOn() != null) {
            builder.setBalancerOn(metrics.getBalancerOn());
        }
        if (metrics.getClusterId() != null) {
            builder.setClusterId(new ClusterId(metrics.getClusterId()).convert());
        }
        if (metrics.getHBaseVersion() != null) {
            builder.setHbaseVersion(FSProtos.HBaseVersionFileContent.newBuilder().setVersion(metrics.getHBaseVersion()));
        }
        return builder.build();
    }

    public static ClusterMetrics toClusterMetrics(ClusterStatusProtos.ClusterStatus proto) {
        ClusterMetricsBuilder builder = ClusterMetricsBuilder.newBuilder();
        builder.setLiveServerMetrics(proto.getLiveServersList().stream().collect(Collectors.toMap(e -> ProtobufUtil.toServerName(e.getServer()), ServerMetricsBuilder::toServerMetrics))).setDeadServerNames(proto.getDeadServersList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList())).setBackerMasterNames(proto.getBackupMastersList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList())).setRegionsInTransition(proto.getRegionsInTransitionList().stream().map(ClusterStatusProtos.RegionInTransition::getRegionState).map(RegionState::convert).collect(Collectors.toList())).setMasterCoprocessorNames(proto.getMasterCoprocessorsList().stream().map(HBaseProtos.Coprocessor::getName).collect(Collectors.toList())).setTableRegionStatesCount(proto.getTableRegionStatesCountList().stream().collect(Collectors.toMap(e -> ProtobufUtil.toTableName(e.getTableName()), e -> ProtobufUtil.toTableRegionStatesCount(e.getRegionStatesCount()))));
        if (proto.hasClusterId()) {
            builder.setClusterId(ClusterId.convert(proto.getClusterId()).toString());
        }
        if (proto.hasHbaseVersion()) {
            builder.setHBaseVersion(proto.getHbaseVersion().getVersion());
        }
        if (proto.hasMaster()) {
            builder.setMasterName(ProtobufUtil.toServerName(proto.getMaster()));
        }
        if (proto.hasBalancerOn()) {
            builder.setBalancerOn(proto.getBalancerOn());
        }
        if (proto.hasMasterInfoPort()) {
            builder.setMasterInfoPort(proto.getMasterInfoPort());
        }
        return builder.build();
    }

    public static ClusterMetrics.Option toOption(ClusterStatusProtos.Option option) {
        switch (option) {
            case HBASE_VERSION: {
                return ClusterMetrics.Option.HBASE_VERSION;
            }
            case LIVE_SERVERS: {
                return ClusterMetrics.Option.LIVE_SERVERS;
            }
            case DEAD_SERVERS: {
                return ClusterMetrics.Option.DEAD_SERVERS;
            }
            case REGIONS_IN_TRANSITION: {
                return ClusterMetrics.Option.REGIONS_IN_TRANSITION;
            }
            case CLUSTER_ID: {
                return ClusterMetrics.Option.CLUSTER_ID;
            }
            case MASTER_COPROCESSORS: {
                return ClusterMetrics.Option.MASTER_COPROCESSORS;
            }
            case MASTER: {
                return ClusterMetrics.Option.MASTER;
            }
            case BACKUP_MASTERS: {
                return ClusterMetrics.Option.BACKUP_MASTERS;
            }
            case BALANCER_ON: {
                return ClusterMetrics.Option.BALANCER_ON;
            }
            case MASTER_INFO_PORT: {
                return ClusterMetrics.Option.MASTER_INFO_PORT;
            }
            case TABLE_TO_REGIONS_COUNT: {
                return ClusterMetrics.Option.TABLE_TO_REGIONS_COUNT;
            }
        }
        throw new IllegalArgumentException("Invalid option: " + option);
    }

    public static ClusterStatusProtos.Option toOption(ClusterMetrics.Option option) {
        switch (option) {
            case HBASE_VERSION: {
                return ClusterStatusProtos.Option.HBASE_VERSION;
            }
            case LIVE_SERVERS: {
                return ClusterStatusProtos.Option.LIVE_SERVERS;
            }
            case DEAD_SERVERS: {
                return ClusterStatusProtos.Option.DEAD_SERVERS;
            }
            case REGIONS_IN_TRANSITION: {
                return ClusterStatusProtos.Option.REGIONS_IN_TRANSITION;
            }
            case CLUSTER_ID: {
                return ClusterStatusProtos.Option.CLUSTER_ID;
            }
            case MASTER_COPROCESSORS: {
                return ClusterStatusProtos.Option.MASTER_COPROCESSORS;
            }
            case MASTER: {
                return ClusterStatusProtos.Option.MASTER;
            }
            case BACKUP_MASTERS: {
                return ClusterStatusProtos.Option.BACKUP_MASTERS;
            }
            case BALANCER_ON: {
                return ClusterStatusProtos.Option.BALANCER_ON;
            }
            case MASTER_INFO_PORT: {
                return ClusterStatusProtos.Option.MASTER_INFO_PORT;
            }
            case TABLE_TO_REGIONS_COUNT: {
                return ClusterStatusProtos.Option.TABLE_TO_REGIONS_COUNT;
            }
        }
        throw new IllegalArgumentException("Invalid option: " + (Object)((Object)option));
    }

    public static EnumSet<ClusterMetrics.Option> toOptions(List<ClusterStatusProtos.Option> options) {
        return options.stream().map(ClusterMetricsBuilder::toOption).collect(Collectors.toCollection(() -> EnumSet.noneOf(ClusterMetrics.Option.class)));
    }

    public static List<ClusterStatusProtos.Option> toOptions(EnumSet<ClusterMetrics.Option> options) {
        return options.stream().map(ClusterMetricsBuilder::toOption).collect(Collectors.toList());
    }

    public static ClusterMetricsBuilder newBuilder() {
        return new ClusterMetricsBuilder();
    }

    private ClusterMetricsBuilder() {
    }

    public ClusterMetricsBuilder setHBaseVersion(String value) {
        this.hbaseVersion = value;
        return this;
    }

    public ClusterMetricsBuilder setDeadServerNames(List<ServerName> value) {
        this.deadServerNames = value;
        return this;
    }

    public ClusterMetricsBuilder setLiveServerMetrics(Map<ServerName, ServerMetrics> value) {
        this.liveServerMetrics.putAll(value);
        return this;
    }

    public ClusterMetricsBuilder setMasterName(ServerName value) {
        this.masterName = value;
        return this;
    }

    public ClusterMetricsBuilder setBackerMasterNames(List<ServerName> value) {
        this.backupMasterNames = value;
        return this;
    }

    public ClusterMetricsBuilder setRegionsInTransition(List<RegionState> value) {
        this.regionsInTransition = value;
        return this;
    }

    public ClusterMetricsBuilder setClusterId(String value) {
        this.clusterId = value;
        return this;
    }

    public ClusterMetricsBuilder setMasterCoprocessorNames(List<String> value) {
        this.masterCoprocessorNames = value;
        return this;
    }

    public ClusterMetricsBuilder setBalancerOn(@Nullable Boolean value) {
        this.balancerOn = value;
        return this;
    }

    public ClusterMetricsBuilder setMasterInfoPort(int value) {
        this.masterInfoPort = value;
        return this;
    }

    public ClusterMetricsBuilder setTableRegionStatesCount(Map<TableName, RegionStatesCount> tableRegionStatesCount) {
        this.tableRegionStatesCount = tableRegionStatesCount;
        return this;
    }

    public ClusterMetrics build() {
        return new ClusterMetricsImpl(this.hbaseVersion, this.deadServerNames, this.liveServerMetrics, this.masterName, this.backupMasterNames, this.regionsInTransition, this.clusterId, this.masterCoprocessorNames, this.balancerOn, this.masterInfoPort, this.tableRegionStatesCount);
    }

    private static class ClusterMetricsImpl
    implements ClusterMetrics {
        @Nullable
        private final String hbaseVersion;
        private final List<ServerName> deadServerNames;
        private final Map<ServerName, ServerMetrics> liveServerMetrics;
        @Nullable
        private final ServerName masterName;
        private final List<ServerName> backupMasterNames;
        private final List<RegionState> regionsInTransition;
        @Nullable
        private final String clusterId;
        private final List<String> masterCoprocessorNames;
        @Nullable
        private final Boolean balancerOn;
        private final int masterInfoPort;
        private final Map<TableName, RegionStatesCount> tableRegionStatesCount;

        ClusterMetricsImpl(String hbaseVersion, List<ServerName> deadServerNames, Map<ServerName, ServerMetrics> liveServerMetrics, ServerName masterName, List<ServerName> backupMasterNames, List<RegionState> regionsInTransition, String clusterId, List<String> masterCoprocessorNames, Boolean balancerOn, int masterInfoPort, Map<TableName, RegionStatesCount> tableRegionStatesCount) {
            this.hbaseVersion = hbaseVersion;
            this.deadServerNames = Preconditions.checkNotNull(deadServerNames);
            this.liveServerMetrics = Preconditions.checkNotNull(liveServerMetrics);
            this.masterName = masterName;
            this.backupMasterNames = Preconditions.checkNotNull(backupMasterNames);
            this.regionsInTransition = Preconditions.checkNotNull(regionsInTransition);
            this.clusterId = clusterId;
            this.masterCoprocessorNames = Preconditions.checkNotNull(masterCoprocessorNames);
            this.balancerOn = balancerOn;
            this.masterInfoPort = masterInfoPort;
            this.tableRegionStatesCount = Preconditions.checkNotNull(tableRegionStatesCount);
        }

        @Override
        public String getHBaseVersion() {
            return this.hbaseVersion;
        }

        @Override
        public List<ServerName> getDeadServerNames() {
            return Collections.unmodifiableList(this.deadServerNames);
        }

        @Override
        public Map<ServerName, ServerMetrics> getLiveServerMetrics() {
            return Collections.unmodifiableMap(this.liveServerMetrics);
        }

        @Override
        public ServerName getMasterName() {
            return this.masterName;
        }

        @Override
        public List<ServerName> getBackupMasterNames() {
            return Collections.unmodifiableList(this.backupMasterNames);
        }

        @Override
        public List<RegionState> getRegionStatesInTransition() {
            return Collections.unmodifiableList(this.regionsInTransition);
        }

        @Override
        public String getClusterId() {
            return this.clusterId;
        }

        @Override
        public List<String> getMasterCoprocessorNames() {
            return Collections.unmodifiableList(this.masterCoprocessorNames);
        }

        @Override
        public Boolean getBalancerOn() {
            return this.balancerOn;
        }

        @Override
        public int getMasterInfoPort() {
            return this.masterInfoPort;
        }

        @Override
        public Map<TableName, RegionStatesCount> getTableRegionStatesCount() {
            return Collections.unmodifiableMap(this.tableRegionStatesCount);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("Master: " + this.getMasterName());
            int backupMastersSize = this.getBackupMasterNames().size();
            sb.append("\nNumber of backup masters: " + backupMastersSize);
            if (backupMastersSize > 0) {
                for (ServerName serverName : this.getBackupMasterNames()) {
                    sb.append("\n  " + serverName);
                }
            }
            int serversSize = this.getLiveServerMetrics().size();
            sb.append("\nNumber of live region servers: " + serversSize);
            if (serversSize > 0) {
                for (ServerName serverName : this.getLiveServerMetrics().keySet()) {
                    sb.append("\n  " + serverName.getServerName());
                }
            }
            int n = this.getDeadServerNames().size();
            sb.append("\nNumber of dead region servers: " + n);
            if (n > 0) {
                for (ServerName serverName : this.getDeadServerNames()) {
                    sb.append("\n  " + serverName);
                }
            }
            sb.append("\nAverage load: " + this.getAverageLoad());
            sb.append("\nNumber of requests: " + this.getRequestCount());
            sb.append("\nNumber of regions: " + this.getRegionCount());
            int n2 = this.getRegionStatesInTransition().size();
            sb.append("\nNumber of regions in transition: " + n2);
            if (n2 > 0) {
                for (RegionState state : this.getRegionStatesInTransition()) {
                    sb.append("\n  " + state.toDescriptiveString());
                }
            }
            return sb.toString();
        }
    }
}

