/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class IdLock {
    private ConcurrentMap<Long, Entry> map = new ConcurrentHashMap<Long, Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getLockEntry(long id) throws IOException {
        Entry existing;
        Entry entry = new Entry(id);
        while ((existing = this.map.putIfAbsent(entry.id, entry)) != null) {
            Entry entry2 = existing;
            synchronized (entry2) {
                if (existing.locked) {
                    ++existing.numWaiters;
                    while (existing.locked) {
                        try {
                            existing.wait();
                        }
                        catch (InterruptedException e) {
                            --existing.numWaiters;
                            throw new InterruptedIOException("Interrupted waiting to acquire sparse lock");
                        }
                    }
                    --existing.numWaiters;
                    existing.locked = true;
                    return existing;
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry tryLockEntry(long id, long time) throws IOException {
        Preconditions.checkArgument(time >= 0L);
        Entry entry = new Entry(id);
        long waitUtilTS = System.currentTimeMillis() + time;
        long remaining = time;
        Entry existing;
        while ((existing = this.map.putIfAbsent(entry.id, entry)) != null) {
            Entry entry2 = existing;
            synchronized (entry2) {
                if (existing.locked) {
                    ++existing.numWaiters;
                    try {
                        while (existing.locked) {
                            existing.wait(remaining);
                            if (!existing.locked) continue;
                            long currentTS = System.currentTimeMillis();
                            if (currentTS >= waitUtilTS) {
                                Entry entry3 = null;
                                return entry3;
                            }
                            remaining = waitUtilTS - currentTS;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Interrupted waiting to acquire sparse lock");
                    }
                    finally {
                        --existing.numWaiters;
                    }
                    existing.locked = true;
                    return existing;
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLockEntry(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            entry.locked = false;
            if (entry.numWaiters > 0) {
                entry.notify();
            } else {
                this.map.remove(entry.id);
            }
        }
    }

    void assertMapEmpty() {
        assert (this.map.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForWaiters(long id, int numWaiters) throws InterruptedException {
        while (true) {
            Entry entry;
            if ((entry = (Entry)this.map.get(id)) != null) {
                Entry entry2 = entry;
                synchronized (entry2) {
                    if (entry.numWaiters >= numWaiters) {
                        return;
                    }
                }
            }
            Thread.sleep(100L);
        }
    }

    public static final class Entry {
        private final long id;
        private int numWaiters;
        private boolean locked = true;

        private Entry(long id) {
            this.id = id;
        }

        public String toString() {
            return "id=" + this.id + ", numWaiter=" + this.numWaiters + ", isLocked=" + this.locked;
        }
    }
}

