/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.framework.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Function;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.schema.DefaultSchemaValidator;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.schema.Schema;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.schema.SchemaViolation;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.cache.CacheLoader;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.cache.LoadingCache;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSet {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Schema> schemas;
    private final Map<String, Schema> pathToSchemas;
    private final List<Schema> regexSchemas;
    private final CacheLoader<String, Schema> cacheLoader = new CacheLoader<String, Schema>(){

        @Override
        public Schema load(String path) throws Exception {
            for (Schema schema : SchemaSet.this.regexSchemas) {
                if (!schema.getPathRegex().matcher(path).matches()) continue;
                SchemaSet.this.log.debug("path -> {}", (Object)schema);
                return schema;
            }
            return nullSchema;
        }
    };
    private final LoadingCache<String, Schema> regexCache = CacheBuilder.newBuilder().softValues().build(this.cacheLoader);
    private static final Schema nullSchema = new Schema("__null__", null, "", "Null schema", new DefaultSchemaValidator(), Schema.Allowance.CAN, Schema.Allowance.CAN, Schema.Allowance.CAN, true, ImmutableMap.of());
    private static final Schema defaultSchema = new Schema("__default__", null, "", "Default schema", new DefaultSchemaValidator(), Schema.Allowance.CAN, Schema.Allowance.CAN, Schema.Allowance.CAN, true, ImmutableMap.of());
    private final boolean useDefaultSchema;

    public static SchemaSet getDefaultSchemaSet() {
        return new SchemaSet(Collections.emptyList(), true){

            @Override
            public String toDocumentation() {
                return "Default schema";
            }
        };
    }

    public SchemaSet(List<Schema> schemas, boolean useDefaultSchema) {
        schemas = Preconditions.checkNotNull(schemas, "schemas cannot be null");
        this.useDefaultSchema = useDefaultSchema;
        this.schemas = Maps.uniqueIndex(schemas, new Function<Schema, String>(){

            @Override
            public String apply(Schema schema) {
                return schema.getName();
            }
        });
        ImmutableMap.Builder<String, Schema> pathBuilder = ImmutableMap.builder();
        ImmutableList.Builder regexBuilder = ImmutableList.builder();
        for (Schema schema : schemas) {
            if (schema.getPath() != null) {
                pathBuilder.put(schema.getPath(), schema);
                continue;
            }
            regexBuilder.add(schema);
        }
        this.pathToSchemas = pathBuilder.build();
        this.regexSchemas = regexBuilder.build();
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    public Schema getSchema(String path) {
        if (this.schemas.size() > 0) {
            Schema schema = this.pathToSchemas.get(path);
            if (schema == null) {
                try {
                    schema = this.regexCache.get(path);
                    if (schema.equals(nullSchema)) {
                        schema = this.useDefaultSchema ? defaultSchema : null;
                    }
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (schema != null) {
                return schema;
            }
        }
        if (this.useDefaultSchema) {
            return defaultSchema;
        }
        throw new SchemaViolation(null, new SchemaViolation.ViolatorData(path, null, null), "No schema found for: " + path);
    }

    public static String getNamedPath(CuratorFramework client, String name) {
        return client.getSchemaSet().getNamedSchema(name).getRawPath();
    }

    public Schema getNamedSchema(String name) {
        return this.schemas.get(name);
    }

    public String toDocumentation() {
        StringBuilder str = new StringBuilder("Curator Schemas:\n\n");
        for (Map.Entry<String, Schema> schemaEntry : this.schemas.entrySet()) {
            str.append(schemaEntry.getKey()).append('\n').append(schemaEntry.getValue().toDocumentation()).append('\n');
        }
        return str.toString();
    }
}

