/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;

public class OperationMetrics {
    private static final String SUBMITTED_COUNT = "SubmittedCount";
    private static final String TIME = "Time";
    private static final String FAILED_COUNT = "FailedCount";
    private final Counter submittedCounter;
    private final Histogram timeHisto;
    private final Counter failedCounter;

    public OperationMetrics(MetricRegistry registry, String metricNamePrefix) {
        Preconditions.checkNotNull(registry);
        Preconditions.checkNotNull(metricNamePrefix);
        this.submittedCounter = registry.counter(metricNamePrefix + SUBMITTED_COUNT);
        this.timeHisto = registry.histogram(metricNamePrefix + TIME);
        this.failedCounter = registry.counter(metricNamePrefix + FAILED_COUNT);
    }

    public Counter getSubmittedCounter() {
        return this.submittedCounter;
    }

    public Histogram getTimeHisto() {
        return this.timeHisto;
    }

    public Counter getFailedCounter() {
        return this.failedCounter;
    }
}

