/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncTableRegionLocatorImpl
implements AsyncTableRegionLocator {
    private final TableName tableName;
    private final AsyncRegionLocator locator;

    public AsyncTableRegionLocatorImpl(TableName tableName, AsyncRegionLocator locator) {
        this.tableName = tableName;
        this.locator = locator;
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row, boolean reload) {
        return this.locator.getRegionLocation(this.tableName, row, RegionLocateType.CURRENT, reload, -1L);
    }
}

