/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableHistogram;

@InterfaceAudience.Private
public abstract class MutableRangeHistogram
extends MutableHistogram
implements MetricHistogram {
    public MutableRangeHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableRangeHistogram(String name, String description) {
        this(name, description, -4L);
    }

    public MutableRangeHistogram(String name, String description, long expectedMax) {
        super(name, description, expectedMax);
    }

    public abstract String getRangeType();

    public abstract long[] getRanges();

    @Override
    public synchronized void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        Snapshot snapshot = this.histogram.snapshot();
        if (snapshot != null) {
            MutableRangeHistogram.updateSnapshotMetrics(this.name, this.desc, this.histogram, snapshot, metricsRecordBuilder);
            this.updateSnapshotRangeMetrics(metricsRecordBuilder, snapshot);
        }
    }

    public void updateSnapshotRangeMetrics(MetricsRecordBuilder metricsRecordBuilder, Snapshot snapshot) {
        long priorRange = 0L;
        long cumNum = 0L;
        long[] ranges = this.getRanges();
        String rangeType = this.getRangeType();
        for (int i = 0; i < ranges.length - 1; ++i) {
            long val = snapshot.getCountAtOrBelow(ranges[i]);
            if (val - cumNum > 0L) {
                metricsRecordBuilder.addCounter(Interns.info(this.name + "_" + rangeType + "_" + priorRange + "-" + ranges[i], this.desc), val - cumNum);
            }
            priorRange = ranges[i];
            cumNum = val;
        }
        long val = this.histogram.getCount();
        if (val - cumNum > 0L) {
            metricsRecordBuilder.addCounter(Interns.info(this.name + "_" + rangeType + "_" + ranges[ranges.length - 1] + "-inf", this.desc), val - cumNum);
        }
    }
}

