/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;

@InterfaceAudience.Private
public class ZNodePaths {
    public static final String META_ZNODE_PREFIX = "meta-region-server";
    public final String baseZNode;
    public final String metaZNodePrefix;
    public final ImmutableMap<Integer, String> metaReplicaZNodes;
    public final String rsZNode;
    public final String drainingZNode;
    public final String masterAddressZNode;
    public final String backupMasterAddressesZNode;
    public final String clusterStateZNode;
    @Deprecated
    public final String tableZNode;
    public final String clusterIdZNode;
    public final String splitLogZNode;
    public final String balancerZNode;
    public final String regionNormalizerZNode;
    public final String switchZNode;
    public final String tableLockZNode;
    public final String recoveringRegionsZNode;
    public final String namespaceZNode;
    public final String masterMaintZNode;

    public ZNodePaths(Configuration conf) {
        this.baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        ImmutableMap.Builder<Integer, String> builder = ImmutableMap.builder();
        this.metaZNodePrefix = conf.get("zookeeper.znode.metaserver", META_ZNODE_PREFIX);
        String defaultMetaReplicaZNode = ZKUtil.joinZNode(this.baseZNode, this.metaZNodePrefix);
        builder.put(0, defaultMetaReplicaZNode);
        int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
        IntStream.range(1, numMetaReplicas).forEachOrdered(i -> builder.put(i, defaultMetaReplicaZNode + "-" + i));
        this.metaReplicaZNodes = builder.build();
        this.rsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.rs", "rs"));
        this.drainingZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.draining.rs", "draining"));
        this.masterAddressZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.master", "master"));
        this.backupMasterAddressesZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.backup.masters", "backup-masters"));
        this.clusterStateZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.state", "running"));
        this.tableZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableEnableDisable", "table"));
        this.clusterIdZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.clusterId", "hbaseid"));
        this.splitLogZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.splitlog", "splitWAL"));
        this.balancerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.balancer", "balancer"));
        this.regionNormalizerZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.regionNormalizer", "normalizer"));
        this.switchZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.switch", "switch"));
        this.tableLockZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.tableLock", "table-lock"));
        this.recoveringRegionsZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.recovering.regions", "recovering-regions"));
        this.namespaceZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.namespace", "namespace"));
        this.masterMaintZNode = ZKUtil.joinZNode(this.baseZNode, conf.get("zookeeper.znode.masterMaintenance", "master-maintenance"));
    }

    public String toString() {
        return "ZNodePaths [baseZNode=" + this.baseZNode + ", metaReplicaZNodes=" + this.metaReplicaZNodes + ", rsZNode=" + this.rsZNode + ", drainingZNode=" + this.drainingZNode + ", masterAddressZNode=" + this.masterAddressZNode + ", backupMasterAddressesZNode=" + this.backupMasterAddressesZNode + ", clusterStateZNode=" + this.clusterStateZNode + ", tableZNode=" + this.tableZNode + ", clusterIdZNode=" + this.clusterIdZNode + ", splitLogZNode=" + this.splitLogZNode + ", balancerZNode=" + this.balancerZNode + ", regionNormalizerZNode=" + this.regionNormalizerZNode + ", switchZNode=" + this.switchZNode + ", tableLockZNode=" + this.tableLockZNode + ", recoveringRegionsZNode=" + this.recoveringRegionsZNode + ", namespaceZNode=" + this.namespaceZNode + ", masterMaintZNode=" + this.masterMaintZNode + "]";
    }

    public boolean isAnyMetaReplicaZNode(String node) {
        return this.metaReplicaZNodes.containsValue(node);
    }

    public String getZNodeForReplica(int replicaId) {
        return Optional.ofNullable(this.metaReplicaZNodes.get(replicaId)).orElseGet(() -> this.metaReplicaZNodes.get(0) + "-" + replicaId);
    }

    public int getMetaReplicaIdFromZnode(String znode) {
        if (znode.equals(this.metaZNodePrefix)) {
            return 0;
        }
        return Integer.parseInt(znode.substring(this.metaZNodePrefix.length() + 1));
    }

    public boolean isDefaultMetaReplicaZnode(String znode) {
        return this.metaReplicaZNodes.get(0).equals(znode);
    }
}

