/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.hadoop.hbase.shaded.org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];

    public static Object invokeConstructor(Class klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[]{arg};
        return ConstructorUtils.invokeConstructor(klass, args);
    }

    public static Object invokeConstructor(Class klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == args) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ConstructorUtils.invokeConstructor(klass, args, parameterTypes);
    }

    public static Object invokeConstructor(Class klass, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor ctor;
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if (args == null) {
            args = emptyObjectArray;
        }
        if (null == (ctor = ConstructorUtils.getMatchingAccessibleConstructor(klass, parameterTypes))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static Object invokeExactConstructor(Class klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[]{arg};
        return ConstructorUtils.invokeExactConstructor(klass, args);
    }

    public static Object invokeExactConstructor(Class klass, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == args) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        int i = 0;
        while (i < arguments) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return ConstructorUtils.invokeExactConstructor(klass, args, parameterTypes);
    }

    public static Object invokeExactConstructor(Class klass, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor ctor;
        if (args == null) {
            args = emptyObjectArray;
        }
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if (null == (ctor = ConstructorUtils.getAccessibleConstructor(klass, parameterTypes))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args);
    }

    public static Constructor getAccessibleConstructor(Class klass, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return ConstructorUtils.getAccessibleConstructor(klass, parameterTypes);
    }

    public static Constructor getAccessibleConstructor(Class klass, Class[] parameterTypes) {
        try {
            return ConstructorUtils.getAccessibleConstructor(klass.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor getAccessibleConstructor(Constructor ctor) {
        if (ctor == null) {
            return null;
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            return null;
        }
        Class clazz = ctor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return ctor;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Constructor getMatchingAccessibleConstructor(Class clazz, Class[] parameterTypes) {
        try {
            ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return ctor;
        }
        catch (NoSuchMethodException e) {
            paramSize = parameterTypes.length;
            ctors = clazz.getConstructors();
            i = 0;
            size = ctors.length;
            ** while (i < size)
        }
lbl-1000:
        // 1 sources

        {
            ctorParams = ctors[i].getParameterTypes();
            ctorParamSize = ctorParams.length;
            if (ctorParamSize == paramSize) {
                match = true;
                n = 0;
                while (n < ctorParamSize) {
                    if (!MethodUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (ctor = ConstructorUtils.getAccessibleConstructor(ctors[i])) != null) {
                    try {
                        ctor.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        // empty catch block
                    }
                    return ctor;
                }
            }
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        return null;
    }
}

