/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.channel.unix;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import org.apache.hadoop.hbase.shaded.io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.EmptyArrays;

public final class Errors {
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    private static final String[] ERRORS = new String[512];
    static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION;
    static final NativeIoException CONNECTION_NOT_CONNECTED_SHUTDOWN_EXCEPTION;
    static final NativeIoException CONNECTION_RESET_EXCEPTION_WRITE;
    static final NativeIoException CONNECTION_RESET_EXCEPTION_WRITEV;
    static final NativeIoException CONNECTION_RESET_EXCEPTION_READ;
    static final NativeIoException CONNECTION_RESET_EXCEPTION_SENDTO;
    static final NativeIoException CONNECTION_RESET_EXCEPTION_SENDMSG;

    static ConnectException newConnectException(String method, int err) {
        return new ConnectException(method + "() failed: " + ERRORS[-err]);
    }

    public static NativeIoException newConnectionResetException(String method, int errnoNegative) {
        NativeIoException exception = Errors.newIOException(method, errnoNegative);
        exception.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return exception;
    }

    public static NativeIoException newIOException(String method, int err) {
        return new NativeIoException(method + "() failed: " + ERRORS[-err], err);
    }

    public static int ioResult(String method, int err, NativeIoException resetCause) throws IOException {
        if (err == ERRNO_EAGAIN_NEGATIVE || err == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (err == resetCause.expectedErr()) {
            throw resetCause;
        }
        if (err == ERRNO_EBADF_NEGATIVE || err == ERRNO_ENOTCONN_NEGATIVE) {
            throw CLOSED_CHANNEL_EXCEPTION;
        }
        throw Errors.newIOException(method, err);
    }

    private Errors() {
    }

    static {
        for (int i = 0; i < ERRORS.length; ++i) {
            Errors.ERRORS[i] = ErrorsStaticallyReferencedJniMethods.strError(i);
        }
        CONNECTION_RESET_EXCEPTION_READ = Errors.newConnectionResetException("syscall:read(...)", ERRNO_ECONNRESET_NEGATIVE);
        CONNECTION_RESET_EXCEPTION_WRITE = Errors.newConnectionResetException("syscall:write(...)", ERRNO_EPIPE_NEGATIVE);
        CONNECTION_RESET_EXCEPTION_WRITEV = Errors.newConnectionResetException("syscall:writev(...)", ERRNO_EPIPE_NEGATIVE);
        CONNECTION_RESET_EXCEPTION_SENDTO = Errors.newConnectionResetException("syscall:sendto(...)", ERRNO_EPIPE_NEGATIVE);
        CONNECTION_RESET_EXCEPTION_SENDMSG = Errors.newConnectionResetException("syscall:sendmsg(...)", ERRNO_EPIPE_NEGATIVE);
        CONNECTION_NOT_CONNECTED_SHUTDOWN_EXCEPTION = Errors.newConnectionResetException("syscall:shutdown(...)", ERRNO_ENOTCONN_NEGATIVE);
        CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    public static final class NativeIoException
    extends IOException {
        private static final long serialVersionUID = 8222160204268655526L;
        private final int expectedErr;

        public NativeIoException(String method, int expectedErr) {
            super(method);
            this.expectedErr = expectedErr;
        }

        public int expectedErr() {
            return this.expectedErr;
        }
    }
}

