/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.google.inject.servlet;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.hbase.shaded.com.google.inject.OutOfScopeException;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.DefaultFilterPipeline;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.FilterPipeline;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.ManagedFilterPipeline;

public class GuiceFilter
implements Filter {
    static final ThreadLocal<Context> localContext = new ThreadLocal();
    static volatile FilterPipeline pipeline = new DefaultFilterPipeline();
    @Inject
    private final FilterPipeline injectedPipeline = null;
    static volatile WeakReference<ServletContext> servletContext = new WeakReference<Object>(null);
    private static final String MULTIPLE_INJECTORS_WARNING = "Multiple Servlet injectors detected. This is a warning indicating that you have more than one " + GuiceFilter.class.getSimpleName() + " running " + "in your web application. If this is deliberate, you may safely " + "ignore this message. If this is NOT deliberate however, " + "your application may not work as expected.";

    @Inject
    static void setPipeline(FilterPipeline pipeline) {
        if (GuiceFilter.pipeline instanceof ManagedFilterPipeline) {
            Logger.getLogger(GuiceFilter.class.getName()).warning(MULTIPLE_INJECTORS_WARNING);
        }
        GuiceFilter.pipeline = pipeline;
    }

    static void reset() {
        pipeline = new DefaultFilterPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Context previous = localContext.get();
        FilterPipeline filterPipeline = null != this.injectedPipeline ? this.injectedPipeline : pipeline;
        try {
            localContext.set(new Context((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse));
            filterPipeline.dispatch(servletRequest, servletResponse, filterChain);
        }
        finally {
            localContext.set(previous);
        }
    }

    static HttpServletRequest getRequest() {
        return GuiceFilter.getContext().getRequest();
    }

    static HttpServletResponse getResponse() {
        return GuiceFilter.getContext().getResponse();
    }

    static ServletContext getServletContext() {
        return (ServletContext)servletContext.get();
    }

    static Context getContext() {
        Context context = localContext.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped object. Either we are not currently inside an HTTP Servlet request, or you may have forgotten to apply " + GuiceFilter.class.getName() + " as a servlet filter for this request.");
        }
        return context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        GuiceFilter.servletContext = new WeakReference<ServletContext>(servletContext);
        FilterPipeline filterPipeline = null != this.injectedPipeline ? this.injectedPipeline : pipeline;
        filterPipeline.initPipeline(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            FilterPipeline filterPipeline = null != this.injectedPipeline ? this.injectedPipeline : pipeline;
            filterPipeline.destroyPipeline();
        }
        finally {
            GuiceFilter.reset();
            servletContext.clear();
        }
    }

    static class Context {
        final HttpServletRequest request;
        final HttpServletResponse response;

        Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

