/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.NettyHBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.Promise;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public class NettyHBaseSaslRpcClientHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Log LOG = LogFactory.getLog(NettyHBaseSaslRpcClientHandler.class);
    private final Promise<Boolean> saslPromise;
    private final UserGroupInformation ugi;
    private final NettyHBaseSaslRpcClient saslRpcClient;
    private final Configuration conf;
    private boolean needProcessConnectionHeader = false;

    public NettyHBaseSaslRpcClientHandler(Promise<Boolean> saslPromise, UserGroupInformation ugi, AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed, Configuration conf) throws IOException {
        this.saslPromise = saslPromise;
        this.ugi = ugi;
        this.conf = conf;
        this.saslRpcClient = new NettyHBaseSaslRpcClient(method, token, serverPrincipal, fallbackAllowed, conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()));
    }

    private void writeResponse(ChannelHandlerContext ctx, byte[] response) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will send token of size " + response.length + " from initSASLContext."));
        }
        ctx.writeAndFlush(ctx.alloc().buffer(4 + response.length).writeInt(response.length).writeBytes(response));
    }

    private void tryComplete(ChannelHandlerContext ctx) {
        if (!this.saslRpcClient.isComplete()) {
            return;
        }
        this.saslRpcClient.setupSaslHandler(ctx.pipeline());
        this.setCryptoAESOption();
        this.saslPromise.setSuccess(true);
    }

    private void setCryptoAESOption() {
        boolean saslEncryptionEnabled = SaslUtil.QualityOfProtection.PRIVACY.getSaslQop().equalsIgnoreCase(this.saslRpcClient.getSaslQOP());
        this.needProcessConnectionHeader = saslEncryptionEnabled && this.conf.getBoolean("hbase.rpc.crypto.encryption.aes.enabled", false);
    }

    public boolean isNeedProcessConnectionHeader() {
        return this.needProcessConnectionHeader;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            byte[] initialResponse = this.ugi.doAs(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return NettyHBaseSaslRpcClientHandler.this.saslRpcClient.getInitialResponse();
                }
            });
            if (initialResponse != null) {
                this.writeResponse(ctx, initialResponse);
            }
            this.tryComplete(ctx);
        }
        catch (Exception e) {
            this.exceptionCaught(ctx, e);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        int len = msg.readInt();
        if (len == -88) {
            this.saslRpcClient.dispose();
            if (this.saslRpcClient.fallbackAllowed) {
                this.saslPromise.trySuccess(false);
            } else {
                this.saslPromise.tryFailure(new FallbackDisallowedException());
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will read input token of size " + len + " for processing by initSASLContext"));
        }
        final byte[] challenge = new byte[len];
        msg.readBytes(challenge);
        byte[] response = this.ugi.doAs(new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return NettyHBaseSaslRpcClientHandler.this.saslRpcClient.evaluateChallenge(challenge);
            }
        });
        if (response != null) {
            this.writeResponse(ctx, response);
        }
        this.tryComplete(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.saslRpcClient.dispose();
        this.saslPromise.tryFailure(new IOException("Connection closed"));
        ctx.fireChannelInactive();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.saslRpcClient.dispose();
        this.saslPromise.tryFailure(cause);
    }
}

