/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.rest.MetricsRESTSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsRESTSourceImpl
extends BaseSourceImpl
implements MetricsRESTSource {
    private MutableFastCounter request;
    private MutableFastCounter sucGet;
    private MutableFastCounter sucPut;
    private MutableFastCounter sucDel;
    private MutableFastCounter sucScan;
    private MutableFastCounter fGet;
    private MutableFastCounter fPut;
    private MutableFastCounter fDel;
    private MutableFastCounter fScan;
    private final MutableFastCounter infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
    private final MutableFastCounter warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
    private final MetricHistogram pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
    private final MetricHistogram pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");

    public MetricsRESTSourceImpl() {
        this("REST", "Metrics about the HBase REST server", "rest", "REST");
    }

    public MetricsRESTSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.request = this.getMetricsRegistry().getCounter("requests", 0L);
        this.sucGet = this.getMetricsRegistry().getCounter("successfulGet", 0L);
        this.sucPut = this.getMetricsRegistry().getCounter("successfulPut", 0L);
        this.sucDel = this.getMetricsRegistry().getCounter("successfulDelete", 0L);
        this.sucScan = this.getMetricsRegistry().getCounter("successfulScanCount", 0L);
        this.fGet = this.getMetricsRegistry().getCounter("failedGet", 0L);
        this.fPut = this.getMetricsRegistry().getCounter("failedPut", 0L);
        this.fDel = this.getMetricsRegistry().getCounter("failedDelete", 0L);
        this.fScan = this.getMetricsRegistry().getCounter("failedScanCount", 0L);
    }

    @Override
    public void incrementRequests(int inc) {
        this.request.incr(inc);
    }

    @Override
    public void incrementSucessfulGetRequests(int inc) {
        this.sucGet.incr(inc);
    }

    @Override
    public void incrementSucessfulPutRequests(int inc) {
        this.sucPut.incr(inc);
    }

    @Override
    public void incrementSucessfulDeleteRequests(int inc) {
        this.sucDel.incr(inc);
    }

    @Override
    public void incrementFailedGetRequests(int inc) {
        this.fGet.incr(inc);
    }

    @Override
    public void incrementFailedPutRequests(int inc) {
        this.fPut.incr(inc);
    }

    @Override
    public void incrementFailedDeleteRequests(int inc) {
        this.fDel.incr(inc);
    }

    @Override
    public void incrementSucessfulScanRequests(int inc) {
        this.sucScan.incr(inc);
    }

    @Override
    public void incrementFailedScanRequests(int inc) {
        this.fScan.incr(inc);
    }

    @Override
    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr(count);
    }

    @Override
    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr(count);
    }

    @Override
    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    @Override
    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

